(function($, Lego) {

Lego.block['b-domik'] = function(params) {

    var thisLoginForm = this,
        lockElem = thisLoginForm.find('.b-domik__lock'),
        socialElem = thisLoginForm.find('.b-domik__social'),
        iconSize = socialElem[0] ? socialElem[0].onclick()['size'] : 0,
        bDomik = arguments.callee,
        timestampInput = $('<input type="hidden" name="timestamp"/>'),
        typeMod = this.attr('class').match(/\bb-domik_type_(\w+)\b/)[1];

    if (socialElem.length && Lego.params['social-host']) {
        if (Lego.params['social-providers']) {
            showSocial(Lego.params['social-providers']);
        } else {
            $.getJSON(Lego.params['social-host'] + '/providers2.jsonp?callback=?', function(data) {
                showSocial(data.providers, data.icon_sprites[iconSize]);
            });
        }

        var broker = new Lego.block['i-social'];
        $('.b-domik__social-link').live('click', function(e) {
            showLoading();
            $('.b-domik__social-popup').each(function() {
                $(this).bem('b-popupa').hide();
            });
            broker.start(
                function() {
                    if (!Lego.params.retpath || top.location.href == Lego.params.retpath)
                        top.location.reload();
                    else
                        top.location.href = Lego.params.retpath;
                },
                function() {
                    socialElem
                        .removeClass('b-domik__social_loading_yes')
                        .css('height', '');
                },
                {provider: this.onclick()['b-domik__social-link'].provider}
            );
            e.preventDefault();
        });
    }

    /**
     * @param {Object} [data]
     */
    function showSocial(data, sprite) {
        if (!data.length) {
            socialElem.remove();
            return;
        }

        socialElem.html(getSocialBlock(data, sprite));
        var bDropdowna = socialElem.find('.b-dropdowna');
        if(!bDropdowna.length) return;

        BEM.DOM.init(bDropdowna);

        var bPopupa = bDropdowna.bem('b-dropdowna').getPopup();

        function onScroll() {
            bPopupa.pos();
        }

        bPopupa
            .on('show', function() {
                $(window).scroll(onScroll);
            })
            .on('hide', function() {
                $(window).unbind('scroll', onScroll);
            });
    }


    /**
     * @nosideeffects
     * @returns {String}
     */
    function getSocialBlock(data, sprite) {
        var bemhtml = [
            {
                block: 'b-domik',
                elem: 'social-title',
                content: Lego.message('b-domik:enter-with', 'Войти при помощи')
            }
        ];

        data = $.grep(data, function(provider) {
            return provider.enabled;
        });

        var visibleIcons = $.grep(data, function(provider) {
            return provider.primary;
        });
        visibleIcons = $.map(visibleIcons, function(provider) {
            return {
                block: 'b-domik',
                tag: 'a',
                elem: 'social-link',
                content: {
                    tag: 'i', elem: 'social-icon', attrs: {
                        'style' : 'background-image:url("' + sprite + '");background-position: 0px -' + (provider.id - 1) * 32 + 'px;'
                    }
                },
                js: {provider: provider.code},
                attrs: {
                    tabIndex: 103
                }
            }
        });

        [].push.apply(bemhtml, visibleIcons);

        function buildRows(data) {

            var allIcons = $.map(data, function(provider) {
                return {
                    block: 'b-domik',
                    tag: 'a',
                    elem: 'social-link',
                    mods: {},
                    attrs: {
                        tabIndex: 103
                    },
                    js: {provider: provider.code},
                    content: [
                        {tag: 'i', elem: 'social-icon', attrs: {
                            'style' : 'background-image:url("' + sprite +'");background-position: 0px -' + (provider.id - 1) * 32 + 'px;'
                        }},
                        provider.display_name
                    ]
                }
            });

            allIcons.length % 2 && (allIcons[allIcons.length] = '');
            var rows = [],
                row;

            for (var i = 0; i < allIcons.length; i++) {
                i % 2 || rows.push(row = {tag: 'tr', content: []});
                row.content.push({tag: 'td', elem: 'provider', content: allIcons[i]});
            }

            return rows;
        }

        // varankinv@: LEGO-5434 (не отображать '...' если все провайдеры primary)
        if(visibleIcons.length < data.length) {
            bemhtml.push({
                tag: 'div',
                block: 'b-dropdowna',
                js: true,
                content: [
                    {
                        elem: 'switcher',
                        tag: 'span',
                        content: {
                            tag: 'a',
                            block: 'b-pseudo-link',
                            mods: {'is-bem': 'yes'},
                            js: true,
                            attrs: {
                                href: Lego.message('b-domik:passport-link', 'https://passport.yandex.ru/'),
                                tabIndex: 103
                            }
                        }
                    },
                    {
                        block: 'b-popupa',
                        js: true,
                        tag: 'div',
                        mix: [
                            {block: 'b-dropdowna', elem: 'popup'},
                            {block: 'b-domik', elem: 'social-popup', mods: {'type': typeMod}}
                        ],
                        content: [
                            { elem: 'tail', tag: 'i' },
                            {
                                elem: 'content',
                                content: [
                                    {elem: 'providers', tag: 'table', content: buildRows(data)}
                                ]
                            }
                        ]
                    }
                ]
            });
        }

        bemhtml.push({
            block: 'b-spin',
            mods: {
                theme: typeMod == 'bigform' ? 'blue-50' : 'blue-16'
            }
        });

        return BEM.HTML.build(bemhtml);
    }


    function showLoading() {
        socialElem
            .css('height', socialElem.height())
            .addClass('b-domik__social_loading_yes');
    }


    bDomik.isHTTPSSupported = true;

    thisLoginForm.append(timestampInput)
        .submit(function() {

            var action = thisLoginForm.attr('action');

            timestampInput.val(+new Date);

            if (action) {
                /^http:/.test(action) &&
                    thisLoginForm.attr('action', action.replace(/^http:/, 'https:'));
            }
        });

    var loginInput = thisLoginForm.find('input[name=login]'),
        passwordInput = thisLoginForm.find('input[name=passwd]'),
        submit = thisLoginForm.find('input[type=submit]');

    loginInput.change(function() {
        var val = loginInput.val();
        val.indexOf('@') == -1 && /[а-яçğıöşü]/i.test(val)?
            showError(params && params.err_msg || Lego.message('b-domik:wrong-keyboard-layout', 'смените раскладку')) :
            hideError();
    });
    loginInput.change();

    passwordInput.change(function() {
        var val = passwordInput.val();
        val.length && /[^0-9a-z!@#\$%\^&\*\(\)_\-\+:;\,\.]/i.test(val)?
            showError(Lego.message('b-domik:wrong-keyboard-layout', 'смените раскладку')) :
            hideError();
    });
    passwordInput.change();

    var errorElem;
    function showError(error) {
        !errorElem &&
            (errorElem = $('<div class="b-domik__error"/>').insertAfter(thisLoginForm.find('.b-domik__password')));
        errorElem.text(error).show();
    }

    function hideError() {
        errorElem && errorElem.hide();
    }

    function getHTTPSHost() {

        var staticHost = Lego.params['lego-static-host'];
        if(staticHost) {
            if(staticHost.indexOf('https:') == 0) {
                return staticHost;
            }
            if(staticHost.indexOf('http:') == 0) {
                return 'https' + staticHost.substr(4);
            }
            if(staticHost.indexOf('//') == 0) {
                return 'https:' + staticHost;
            }
            else {
                return 'https://' + location.host + staticHost;
            }
        } else {
            return 'https://' + location.host;
        }
    }

    // LEGO-10198
    bDomik.checkForHTTPS = function checkForHTTPS() { };
    bDomik.enableHTTPS = function() { lockElem.addClass('b-domik__lock_visibility_visible'); };
    bDomik.enableHTTPS();

    var getLockBaloonContent = bDomik.getLockBaloonContent || function() {
            // HACK (varankinv@): заменяем "((link))" на <a href="">link</a>
            var _linkRe = /\(\(([^\)]+)\)\)/g;
            function makeLinkContent(t, url) {
                return t.replace(_linkRe, '<a class="b-link" href="' + url +'">$1</a>');
            }

            var text = Lego.message('b-domik.lock-balloon:content', 'Логин и пароль будут передаваться в&#160;((безопасном режиме))');
            return makeLinkContent(text, Lego.message('b-domik.lock-balloon:linkHref', 'http://help.yandex.ru/mail/?id=1113446'));
        },
        balloon = $(BEM.HTML.build({
            block: 'b-popupa',
            mods: {
                direction: 'right',
                theme: 'feffd6'
            },
            mix: [{block: 'b-domik', elem: 'lock-balloon'}],
            content: [
                { elem: 'tail', tag: 'i' },
                {
                    elem: 'content',
                    content : getLockBaloonContent()
                }
            ]
        }));

    thisLoginForm.append(balloon);

    var bemBalloon = balloon.bem('b-popupa'),
        balloonDelay = 300,
        timerId;

    function hideBalloon() {
        timerId = setTimeout(function(){
            bemBalloon.hide();
        }, balloonDelay);
    }

    var eventBound;

    function showBalloon() {
        timerId && clearTimeout(timerId);
        timerId = null;
        bemBalloon.show(lockElem);

        if(!eventBound) {
            eventBound = true;
            balloon.hover(showBalloon, hideBalloon);
        }
    }

    lockElem.hover(showBalloon, hideBalloon);

};

})(jQuery, window.Lego);
