<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-domik"/>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-domik" mode="lego:block-class-js">
    <xsl:text> g-js</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-domik" mode="lego:js-params-content">
    <xsl:text>name:</xsl:text><xsl:value-of select="x:js-quote(concat(lego:name(.), '_type_', @lego:type))"/>
</xsl:template>

<xsl:template match="lego:b-domik/lego:register" mode="lego:js-params-content">
    <xsl:apply-templates select="." mode="lego:js-params-regtitle"/>
    <xsl:apply-templates select="." mode="lego:js-params-regmode"/>
</xsl:template>

<xsl:template match="lego:b-domik/lego:register" mode="lego:js-params-regtitle"/>
<xsl:template match="lego:b-domik/lego:register[string(.)]" mode="lego:js-params-regtitle">
    <xsl:text>,register:</xsl:text><xsl:value-of select="x:js-quote(lego:register)"/>
</xsl:template>

<xsl:template match="lego:b-domik/lego:register" mode="lego:js-params-regmode"/>
<xsl:template match="lego:b-domik/lego:register[@mode]" mode="lego:js-params-regmode">
    <xsl:text>,regMode:</xsl:text><xsl:value-of select="x:js-quote(@mode)"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-domik" mode="lego:content">
    <div class="{lego:name(.)}__form">
        <xsl:apply-templates select="." mode="lego:top"/>
        <xsl:apply-templates select="lego:social" />
        <xsl:apply-templates select="lego:register"/>
        <xsl:apply-templates select="." mode="lego:remember"/>
    </div>
</xsl:template>

<xsl:template match="lego:b-domik" mode="lego:top">
    <xsl:apply-templates select="lego:title"/>
    <xsl:apply-templates select="lego:username"/>
    <xsl:apply-templates select="lego:password"/>
    <xsl:apply-templates select="." mode="lego:permanent"/>
    <xsl:apply-templates select="." mode="lego:submit"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-domik" mode="lego:action-content">
    <xsl:value-of select="$lego:params/lego:passport-host"/>
    <xsl:text>/auth?from=</xsl:text>
    <xsl:value-of select="x:urlencode('utf-8', $lego:params/lego:passport-msg)"/>
    <xsl:if test="$lego:params/lego:retpath">
        <xsl:text>&amp;retpath=</xsl:text><xsl:value-of select="x:urlencode('utf-8', $lego:params/lego:retpath)"/>
    </xsl:if>
</xsl:template>

<xsl:template match="lego:b-domik" mode="lego:method-content">
    <xsl:text>post</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-domik/lego:title">
    <div class="{lego:name(..)}__title">
        <xsl:apply-templates select="." mode="lego:content"/>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-domik/lego:username | lego:b-domik/lego:password">
    <div class="{lego:name(..)}__{local-name()}">
        <xsl:apply-templates select="lego:input"/>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-domik//lego:input">
    <xsl:apply-templates select="lego:*"/>
    <div class="b-input">
        <input class="b-input__text">
            <xsl:apply-templates select="." mode="lego:attributes"/>
            <xsl:apply-templates select="." mode="lego:input-attributes"/>
        </input>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-domik//lego:input[lego:hint]" mode="lego:id-content">
    <xsl:value-of select="concat('b-domik-', local-name(..))"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-domik//lego:input[@name = 'login']" mode="lego:tabindex-content">
    <xsl:text>100</xsl:text>
</xsl:template>

<xsl:template match="lego:b-domik//lego:input[@name = 'passwd']" mode="lego:tabindex-content">
    <xsl:text>101</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-domik" mode="lego:permanent">
    <div class="{lego:name(.)}__permanent">
        <xsl:apply-templates select="." mode="lego:check"/>
        <xsl:apply-templates select="." mode="lego:help"/>
    </div>
</xsl:template>

<xsl:template match="lego:b-domik" mode="lego:check">
    <input id="{lego:name(.)}-permanent" class="{lego:name(.)}__check" name="twoweeks" type="checkbox" value="yes" tabindex="102"/>
    <label for="{lego:name(.)}-permanent" class="b-domik__permanent-label">
        <xsl:value-of select="lego:message('b-domik:permanent', 'запомнить меня')"/>
    </label>
</xsl:template>

<xsl:template match="lego:b-domik" mode="lego:help">
    <xsl:text> </xsl:text>
    <span class="{lego:name(.)}__help">(<a class="{lego:name(.)}__link" href="{lego:message('b-domik:help-link', 'http://help.yandex.ru/passport/?id=922493')}" tabindex="106">
        <xsl:value-of select="lego:message('b-domik:help', 'что&#160;это')"/>
    </a>)</span>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-domik" mode="lego:submit">
    <div class="{lego:name(.)}__button">
        <input class="{lego:name(.)}__submit" type="submit" value="{lego:message('b-domik:logon', 'Войти')}" tabindex="103"/>
    </div>
</xsl:template>

<xsl:template match="lego:b-domik" mode="lego:remember">
    <div class="{lego:name(.)}__remember">
        <a class="{lego:name(.)}__remind" href="{$lego:params/lego:passport-host}/passport?mode=restore" tabindex="105">
            <xsl:value-of select="lego:message('b-domik:remember', 'Вспомнить пароль')"/>
        </a>
    </div>
</xsl:template>

<xsl:template match="lego:b-domik/lego:register">
    <div class="{lego:name(..)}__register">
        <a class="{lego:name(..)}__link" tabindex="104">
            <xsl:apply-templates select="." mode="lego:url"/>
            <xsl:apply-templates select="." mode="lego:text"/>
        </a>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-domik/lego:register" mode="lego:url-content">
    <xsl:value-of select="$lego:params/lego:passport-host"/>
    <xsl:text>/passport?mode=</xsl:text>
    <xsl:apply-templates select="." mode="lego:regmode"/>
    <xsl:if test="$lego:params/lego:yandexuid">
        <xsl:text>&amp;yu=</xsl:text><xsl:value-of select="$lego:params/lego:yandexuid"/>
    </xsl:if>
    <xsl:if test="$lego:params/lego:retpath">
        <xsl:text>&amp;retpath=</xsl:text><xsl:value-of select="x:urlencode('utf-8', $lego:params/lego:retpath)"/>
    </xsl:if>
    <xsl:if test="$lego:params/lego:passport-msg">
        <xsl:text>&amp;from=</xsl:text><xsl:value-of select="x:urlencode('utf-8', $lego:params/lego:passport-msg)"/>
    </xsl:if>
</xsl:template>

<xsl:template match="lego:b-domik/lego:register" mode="lego:regmode">
    <xsl:text>register</xsl:text>
</xsl:template>

<xsl:template match="lego:b-domik/lego:register[@mode]" mode="lego:regmode">
    <xsl:value-of select="@mode"/>
</xsl:template>

<xsl:template match="lego:b-domik/lego:register" mode="lego:text">
    <xsl:value-of select="."/>
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>
