(function($, Lego){

Lego.block['b-dropdown'] = function(params){
    var thisDropdown = $(this),
        thisDropdownList,
        dropdownPopup,
        dropdownIframe,
        dropdownSpacer,
        hidden = false,
        inited = false,
        init = function() {
            thisDropdownList = thisDropdown.find('.b-dropdown__list');
            dropdownPopup = $('<div class="b-dropdown__popup"/>');
            dropdownIframe = $('<iframe class="b-dropdown__iframe" frameborder="0" src="javascript:' + "'<body style=\\'background:none;overflow:hidden\\'>'" + '"/>');
            dropdownSpacer = thisDropdownList.clone(true).addClass('b-dropdown__list_clone').hide();
            thisDropdownList.before(dropdownPopup);
            dropdownPopup.after(dropdownSpacer);
            hide();
            $(document)
                // нажатие Esc и клик вне попапа скрывают его
                .keydown(function(e){ if(e.keyCode == 27 && !(e.metaKey || e.ctrlKey || e.altKey || e.shiftKey)) hide() })
                .click(function(e) { if(!$(e.target).is('.b-dropdown *')) hide() })
                .bind('popupsClose.lego', hide);
            inited = true;
        },
        hide = (function(){
            if (hidden) return;
            dropdownPopup
                .css('visibility', 'hidden')
                .before(thisDropdownList)
                .hide();
            dropdownSpacer.hide();
            hidden = true;
        });

    thisDropdown.find('.b-dropdown__or').click(function(e){
        e.preventDefault();
        if(!inited) init();
        if (thisDropdown.hasClass("b-dropdown_state_disabled")) {
            thisDropdown.trigger('popupDisabled.lego');
            return;
        }
        if (hidden) {
            $(document).trigger('popupsClose.lego', { source : thisDropdown[0] });
            var oe = $.Event('popupOpen.lego');
            thisDropdown.trigger(oe);
            if (!oe.isDefaultPrevented()) {
                dropdownSpacer.css('display', '');

                dropdownPopup
                    .append(thisDropdownList)
                    .css('visibility', '');

                if(params.direction == 'up' || thisDropdown.hasClass('b-dropdown_direction_up')) {
                    var dropdownHeight = dropdownPopup.height() - dropdownSpacer.height();
                    dropdownPopup
                        .css('margin-top', -(dropdownHeight - (
                            parseInt(thisDropdownList.css('padding-bottom'), 10) +
                            parseInt($(this).closest('.b-dropdown__item').css('padding-bottom'), 10))));
                }

                dropdownPopup
                    .prepend(dropdownIframe)
                    .css('display', '');
                hidden = false;
            }
        } else { hide() }
    });
};

})(jQuery, window.Lego);

