<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:exsl="http://exslt.org/common"
    extension-element-prefixes=" exsl "
    exclude-result-prefixes=" lego exsl "
    version="1.0">

    <xsl:import href="b-dropdowna.convert2xml.xsl"/>

    <xsl:template match="lego:b-dropdown" mode="dropdown-to-dropdowna">
        <xsl:param name="is-in-footer" select="false()"/>
        <xsl:variable name="dropdowna">
            <lego:b-dropdowna>
                <xsl:apply-templates select="lego:or" mode="dropdown-to-dropdowna"/>
                <xsl:apply-templates select="." mode="dropdown-to-dropdowna-popup">
                    <xsl:with-param name="is-in-footer" select="$is-in-footer"/>
                </xsl:apply-templates>
            </lego:b-dropdowna>
        </xsl:variable>
        <xsl:apply-templates select="exsl:node-set($dropdowna)"/>
    </xsl:template>

    <xsl:template match="lego:b-dropdown" mode="dropdown-to-dropdowna-popup">
        <xsl:param name="is-in-footer" select="false()"/>
        <lego:b-popupa>
            <xsl:apply-templates select="." mode="dropdown-to-dropdowna-popup-attributes">
                <xsl:with-param name="is-in-footer" select="$is-in-footer"/>
            </xsl:apply-templates>
            <xsl:apply-templates select="." mode="dropdown-to-dropdowna-popup-content"/>
        </lego:b-popupa>
    </xsl:template>

    <xsl:template match="lego:b-dropdown" mode="dropdown-to-dropdowna-popup-attributes">
        <xsl:param name="is-in-footer" select="false()"/>
        <xsl:copy-of select="@lego:direction"/>
    </xsl:template>

    <xsl:template match="lego:b-dropdown" mode="dropdown-to-dropdowna-popup-content">
        <lego:tail/>
        <lego:content>
            <lego:b-menu lego:layout="vert" lego:preset="vmenu">
                <xsl:apply-templates select="lego:item" mode="dropdown-to-dropdowna"/>
            </lego:b-menu>
        </lego:content>
    </xsl:template>

    <xsl:template match="lego:b-dropdown/lego:or" mode="dropdown-to-dropdowna">
        <lego:switcher>
            <lego:b-pseudo-link lego:is-bem="yes">
                <xsl:copy-of select="@url"/>
                <xsl:copy-of select=".//lego:b-pseudo-link/@*"/>
                <xsl:copy-of select="lego:text/lego:b-pseudo-link/node()"/>
            </lego:b-pseudo-link>
        </lego:switcher>
    </xsl:template>

    <xsl:template match="lego:b-dropdown/lego:item" mode="dropdown-to-dropdowna"/>

    <xsl:template match="lego:b-dropdown/lego:item[lego:*]" mode="dropdown-to-dropdowna">
        <xsl:apply-templates select="@separator" mode="dropdown-to-dropdowna"/>
        <xsl:copy>
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates select="lego:*" mode="dropdown-to-dropdowna"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="lego:b-dropdown/lego:item/@separator" mode="dropdown-to-dropdowna">
        <lego:separator/>
    </xsl:template>

    <xsl:template match="lego:b-dropdown/lego:item/lego:link" mode="dropdown-to-dropdowna">
        <lego:b-link>
            <xsl:copy-of select="@*"/>
            <xsl:copy-of select="node()"/>
        </lego:b-link>
    </xsl:template>

    <xsl:template match="lego:b-dropdown/lego:item/lego:*" mode="dropdown-to-dropdowna">
        <xsl:copy-of select="."/>
    </xsl:template>

</xsl:stylesheet>
