BEM.DOM.decl('b-flash', {

    onSetMod : {

        js : function() {

            var _this = this,
                params = _this.params,
                iframe = $(BEM.HTML.build({
                        block : _this.__self.getName(),
                        elem : 'container',
                        tag : 'iframe',
                        attrs : {
                            src : 'about:blank',
                            frameborder : 0,
                            allowtransparency : true,
                            width : params.width,
                            height : params.height
                        }
                    }))
                    .appendTo(_this.domElem)[0],
                dom = iframe.contentDocument || (iframe.contentWindow ? iframe.contentWindow.document : iframe.document);

            params.attributes.id = params.id;

            dom.open();
            dom.write('<html><head><title><\/title>');
            dom.write('<style>*{margin:0;padding:0;outline:none;border:0;}body{overflow:hidden;background:transparent}html,body{width:100%; height:100%}#bFlash{width:100%; height:100%;}<\/style>');
            dom.write('<\/head><body>');
            dom.write('<div id="bFlash"><\/div>');
            dom.write('<script>' +
                            'var flashvars = {},' +
                            '    params = {},'+
                            '    attributes = {}; ' +
                            $.map(['params', 'attributes', 'flashvars'], function(value) {

                                return value == 'flashvars'?
                                    _this._buildFlashParams(value, true) :
                                    _this._buildFlashParams(value, false);

                            }).join('') + ' ' +
                            'function bFlashInitSwfObject() {\'swfobject\' in window && swfobject.embedSWF(' +
                                '"' + params.src + '", ' + // путь к file.swf
                                '"bFlash", ' +    // id альтернативного контента, не менять
                                '"100%", ' +    // width
                                '"100%", "' +   // height
                                params.version + '", ' +   // min flash version
                                '"' + params.expressinstall + '", ' + // путь к expressInstall.swf
                                'flashvars, ' + //  flashvars {name1:"hello",name2:"world",name3:"foobar"}
                                'params, ' +    //  params {menu:"false"}
                                'attributes, ' +    // attributes {id:"myDynamicContent",name:"myDynamicContent"}
                                'function(e) {' +
                                    'parent.BEM.blocks[\''+params.name+'\']._onSWFObjectComplete("' + _this._uniqId + '", e.success);' +
                                '});}' +
                        '<\/script>');
            dom.write('<script src="' + params.swfobject + '"'+
                        ($.browser.msie?
                            ' defer="defer" onreadystatechange="bFlashInitSwfObject();" ' :
                            ' onLoad="bFlashInitSwfObject();" ')
                        +'><\/script>');
            dom.write('<\/body><\/html>');
            dom.close();

        }

    },

    _buildFlashParams : function(type, urlencode) {

        var params = this.params[type],
            res = [];

        params && $.each(params, function(i, val) {
            res.push(type, '.', i, '="', urlencode ? encodeURIComponent(val) : val, '";');
        });

        return res.join('');

    },

    getDefaultParams : function() {

        return {
            version : '10.0.0',
            width : '100%',
            height : '100%',
            attributes : {},
            swfobject : 'http://yastatic.net/swfobject/2.2/swfobject.min.js',
            expressinstall : 'http://yastatic.net/swfobject/2.2/expressInstall.swf'
        };

    }

}, {

    _onSWFObjectComplete : function(id, status) {

        var block = BEM.DOM.getBlockByUniqId(id);
        block.elem(status? 'altcontent' : 'container').remove();
        block.elem(status? 'container' : 'altcontent').show();

    }

});
