<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<xsl:template match="lego:b-flash">
    <div>
        <xsl:attribute name="style">
            <xsl:apply-templates select="@width | @height" mode="lego:css-size"/>
        </xsl:attribute>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>
        <div class="{lego:name(.)}__altcontent">
            <xsl:apply-templates select="lego:altcontent" mode="lego:content"/>
        </div>
    </div>
</xsl:template>

<xsl:template match="lego:b-flash/@*" mode="lego:css-size">
    <xsl:value-of select="name()"/>
    <xsl:text>:</xsl:text>
    <xsl:choose>
        <xsl:when test="contains(., 'px')">
            <xsl:value-of select="."/>
        </xsl:when>
        <xsl:when test="contains(., '%')">
            <xsl:value-of select="."/>
        </xsl:when>
        <xsl:otherwise>
            <xsl:value-of select="."/>
            <xsl:text>px</xsl:text>
        </xsl:otherwise>
    </xsl:choose>
    <xsl:text>;</xsl:text>
</xsl:template>

<xsl:template match="lego:b-flash" mode="lego:block-class-js">
   <xsl:text> i-bem</xsl:text>
</xsl:template>

<xsl:template match="lego:b-flash" mode="lego:js-params-content">
    <xsl:apply-imports />
    <xsl:apply-templates
        select="
            @version | @id | @src | @width | @height | @swfobject | @expressinstall |
            lego:attributes | lego:params | lego:flashvars"
        mode="lego:js-params-content"/>
</xsl:template>

<xsl:template
    match="
        lego:b-flash/@version | lego:b-flash/@id | lego:b-flash/@src | lego:b-flash/@width |
        lego:b-flash/@height | lego:b-flash/@swfobject | lego:b-flash/@expressinstall"
    mode="lego:js-params-content">
    <xsl:value-of select="concat(',', local-name(), ':', x:js-quote(.))"/>
</xsl:template>

<xsl:template
    match="lego:b-flash/lego:attributes | lego:b-flash/lego:params | lego:b-flash/lego:flashvars"
    mode="lego:js-params-content">
    <xsl:value-of select="concat(',', local-name(), ':{')"/>
    <xsl:apply-templates select="lego:attribute | lego:param | lego:flashvar" mode="lego:js-params-content"/>
    <xsl:text>}</xsl:text>
</xsl:template>

<xsl:template
    match="
        lego:b-flash/lego:attributes/lego:attribute |
        lego:b-flash/lego:params/lego:param |
        lego:b-flash/lego:flashvars/lego:flashvar"
    mode="lego:js-params-content">
    <xsl:if test="position() &gt; 1">,</xsl:if>
    <xsl:value-of select="concat(@name, ':', x:js-quote(@value))"/>
</xsl:template>

</xsl:stylesheet>
