<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-foot//lego:lang">
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="lego:link[not(@lang = $lego:locale)]"/>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-foot//lego:lang/lego:link">
    <xsl:if test="position() &gt; 1">
        <xsl:text> </xsl:text>
    </xsl:if>
    <a class="b-foot__link">
        <xsl:apply-templates select="." mode="lego:url"/>
        <img class="b-foot__lang__flag" src="{$lego:lego-static-host}/blocks/b-foot/lang/b-foot__lang__{@lang}.gif" alt=""/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </a>
</xsl:template>

</xsl:stylesheet>