<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    extension-element-prefixes=" x "
    exclude-result-prefixes=" x lego "
    version="1.0">

    <xsl:template match="lego:b-form-button">
        <lego:declaration>
            <lego:b-form-button lego:focused="yes" lego:disabled="yes" lego:hovered="yes" lego:pressed="yes">
                <lego:input/>
                <lego:click/>
            </lego:b-form-button>
        </lego:declaration>

        <lego:b-form-button lego:theme="grey-19" lego:height="19">
            <xsl:copy-of select="@*"/>
            <xsl:copy-of select="lego:mix"/>
            <lego:left/>
            <lego:content>
                <lego:text>
                    <xsl:apply-templates select="text() | node()[not(local-name() = 'mix')]"/>
                </lego:text>
            </lego:content>
            <xsl:if test="@url">
                <lego:click/>
            </xsl:if>
            <xsl:if test="@type">
                <lego:input type="{@type}"/>
            </xsl:if>
        </lego:b-form-button>

    </xsl:template>

</xsl:stylesheet>
