<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<xsl:strip-space elements="lego:b-form-button"/>

<xsl:template match="lego:b-form-button">
    <xsl:element name="{x:if(@url, 'a', 'span')}">
        <xsl:apply-templates select="." mode="lego:url"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>
        <xsl:copy-of select="@target | @id | @tabindex"/>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:wai"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </xsl:element>
</xsl:template>

<xsl:template match="lego:b-form-button" mode="lego:block-class-js">
    <xsl:text> i-bem</xsl:text>
</xsl:template>

<xsl:template match="lego:b-form-button" mode="lego:js-params">
    <xsl:attribute name="onclick">
        <xsl:text>return {</xsl:text>
        <xsl:value-of select="x:js-quote(lego:name(.))"/>
        <xsl:text>:{</xsl:text>
        <xsl:apply-templates select="." mode="lego:js-params-content"/>
        <xsl:text>}</xsl:text>
        <xsl:apply-templates select="." mode="lego:js-params-mix"/>
        <xsl:text>}</xsl:text>
    </xsl:attribute>
</xsl:template>

<xsl:template match="lego:b-form-button" mode="lego:wai">
    <xsl:attribute name="role">button</xsl:attribute>
    <!--xsl:attribute name="tabindex">0</xsl:attribute-->
    <xsl:if test="@lego:disabled = 'yes'">
        <xsl:attribute name="aria-disabled">true</xsl:attribute>
    </xsl:if>
</xsl:template>

<xsl:template match="lego:b-form-button/lego:left">
    <i>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
    </i>
</xsl:template>

<xsl:template match="lego:b-form-button/lego:content | lego:b-form-button//lego:text">
    <span>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </span>
</xsl:template>

</xsl:stylesheet>
