<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<xsl:template match="lego:b-form-checkbox">
    <span>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </span>
</xsl:template>

<xsl:template match="lego:b-form-checkbox[not(@lego:size)]" mode="lego:block-class-content">
    <xsl:apply-imports/>
    <xsl:text> b-form-checkbox_size_13</xsl:text>
</xsl:template>

    <xsl:template match="lego:b-form-checkbox//lego:tick">
        <i>
            <xsl:apply-templates select="." mode="lego:block-attributes"/>
        </i>
    </xsl:template>

    <xsl:template match="lego:b-form-checkbox/lego:bg">
        <i>
            <xsl:apply-templates select="." mode="lego:block-attributes"/>
            <xsl:apply-templates select="lego:tick"/>
        </i>
    </xsl:template>

<xsl:template match="lego:b-form-checkbox/lego:checkbox">
    <input type="checkbox">
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select=".." mode="lego:input-attributes"/>

        <xsl:if test="../@lego:disabled = 'yes'">
            <xsl:attribute name="disabled">disabled</xsl:attribute>
        </xsl:if>
    </input>
</xsl:template>

</xsl:stylesheet>