<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-form-input[@lego:autocomplete = 'yes']" mode="lego:js-params-content">
    <xsl:apply-imports/>
    <xsl:if test="@update-on-enter = 'no'">
        <xsl:text>,updateOnEnter:false</xsl:text>
    </xsl:if>
    <xsl:if test="lego:popup">
        <xsl:text>,popupMods:{</xsl:text>
        <xsl:for-each select="lego:popup/@lego:*">
            <xsl:if test="position() &gt; 1">,</xsl:if>
            <xsl:value-of select="concat(local-name(), ':', x:js-quote(.))"/>
        </xsl:for-each>
        <xsl:text>}</xsl:text>
    </xsl:if>
    <xsl:text>,dataprovider:{</xsl:text>
    <xsl:apply-templates select="lego:dataprovider/@name | lego:dataprovider/@url" mode="lego:js-params-content"/>
    <xsl:text>}</xsl:text>
</xsl:template>

</xsl:stylesheet>
