<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<xsl:template match="lego:b-form-input[@lego:type = 'textarea']/lego:input">
    <xsl:call-template name="lego:box">
        <xsl:with-param name="content">
            <textarea cols="10" rows="10">
                <xsl:apply-templates select="." mode="lego:block-attributes"/>
                <xsl:apply-templates select="." mode="lego:content"/>
            </textarea>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:b-form-input[@lego:type = 'textarea']/lego:input" mode="lego:block-attributes">
    <xsl:apply-imports/>
    <xsl:apply-templates select="." mode="lego:cols"/>
    <xsl:apply-templates select="." mode="lego:rows"/>
</xsl:template>

<xsl:template match="lego:b-form-input[@lego:type = 'textarea']/lego:input" mode="lego:cols"/>
<xsl:template match="lego:b-form-input[@lego:type = 'textarea']/lego:input[@cols]" mode="lego:cols">
    <xsl:attribute name="cols">
        <xsl:value-of select="@cols"/>
    </xsl:attribute>
</xsl:template>

<xsl:template match="lego:b-form-input[@lego:type = 'textarea']/lego:input" mode="lego:rows"/>
<xsl:template match="lego:b-form-input[@lego:type = 'textarea']/lego:input[@rows]" mode="lego:rows">
    <xsl:attribute name="rows">
        <xsl:value-of select="@rows"/>
    </xsl:attribute>
</xsl:template>

</xsl:stylesheet>