<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-form-input">
    <span>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </span>
</xsl:template>

<xsl:template match="lego:b-form-input[lego:message[@lego:type and @lego:visibility = 'visible']]" mode="lego:block-class-content">
    <xsl:apply-imports/>
    <xsl:value-of select="concat(' ', lego:name(.), '_message-', lego:message/@lego:type, '_', lego:message/@lego:visibility)"/>
</xsl:template>

<xsl:template match="lego:b-form-input" mode="lego:block-class-js">
    <xsl:text> i-bem</xsl:text>
</xsl:template>

<xsl:template match="lego:b-form-input" mode="lego:js-params-content">
    <xsl:apply-imports/>
    <xsl:if test="@autofocus = 'yes'">,autoFocus:true</xsl:if>
</xsl:template>

<xsl:template match="lego:b-form-input" mode="lego:id-content">
    <xsl:apply-templates select="." mode="lego:auto-id-content"/>
</xsl:template>

<xsl:template match="lego:b-form-input/lego:input">
    <xsl:call-template name="lego:box">
        <xsl:with-param name="content">
            <input>
                <xsl:apply-templates select="." mode="lego:block-attributes"/>
            </input>
            <xsl:apply-templates select="lego:clear" />
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:b-form-input/lego:input" mode="lego:block-attributes">
    <xsl:apply-imports/>
    <xsl:apply-templates select="ancestor::lego:b-form-input[1]" mode="lego:input-attributes"/>
</xsl:template>

<xsl:template name="lego:box">
    <xsl:param name="content"/>
    <span class="b-form-input__box">
        <xsl:copy-of select="$content"/>
    </span>
</xsl:template>

</xsl:stylesheet>
