BEM.DOM.decl('b-form-radio', {

    onSetMod: {

        'js' : function() {

            var _this = this,
                activeNode = $.browser.msie ? null : _this.__self.doc[0].activeElement;

            _this._val = this.findElem(this.elem('button', 'checked', 'yes'), 'radio').val() || '';

            _this.elem('radio').each(function() {
                var mods = [];

                activeNode === this && (mods.push('focused'));
                this.checked && (mods.push('checked'));

                if(mods[0]) {
                    var button = _this.__self._getButtonByElem($(this));
                    $.each(mods, function(i, modName) {
                        _this.setMod(button, modName, 'yes');
                    });
                }
            });

            if($.browser.msie) {
                $(window).load(function() {
                    activeNode = _this.__self.doc[0].activeElement;

                    _this.elem('radio').each(function() {
                        if(activeNode === this) {
                            var button = _this.__self._getButtonByElem($(this));

                            _this.setMod(button, 'focused', 'yes');
                        }
                    });
                });
            };

        }

    },

    onElemSetMod : {

        'button' : {

            'focused' : {

                'yes' : function(elem) {
                    this
                        .delMod(this.elem('button', 'focused', 'yes'), 'focused')
                        .findElem(elem, 'radio').focus();
                }

            },

            'checked' : {

                'yes' : function(elem) {
                    this.setMod(elem.next(), 'next-for-checked', 'yes');

                    this._val = this
                        .findElem(elem, 'radio')
                        .attr('checked', true)
                        .val();

                    var prev = this.elem('button', 'checked', 'yes');
                    this.delMod(prev, 'checked');

                    this.trigger('change', {
                        current: elem,
                        prev: prev
                    });
                },

                '' : function(elem) {
                    this.delMod(elem.next(), 'next-for-checked');
                }

            },

            'next-for-checked' : {

                'yes' : function() {
                    this.delMod(this.elem('button', 'next-for-checked', 'yes'), 'next-for-checked');
                }

            },

            'disabled' : function(elem, modName, modVal) {

                elem.find(this.buildSelector('radio')).attr('disabled', modVal == 'yes');

            }

        }

    },

    /**
     * @param {String} [val]
     * @returns {String|BEM.DOM} элемент с заданным value
     */
    val : function(val) {

        if(typeof val == 'undefined') {
            return this._val;
        } else {
            var _this = this;
            this.elem('radio').each(function() {
                if(this.value == val) {
                    _this.setMod(_this.__self._getButtonByElem($(this)), 'checked', 'yes');
                    return false;
                }
            });
            return _this;
        }

    },

    /**
     * @returns {BEM.DOM}
     */
    uncheckAll : function() {

        var button = this.elem('button', 'checked', 'yes');

        this
            .delMod(button, 'checked')
            .findElem(button, 'radio').attr('checked', false);

        return this;

    }

}, {

    live : function() {

        this
            .liveBindTo('radio', 'leftclick', function(e) {
                if(!e.target.disabled) {
                    var button = this.__self._getButtonByElem(e.data.domElem);
                    this
                        .setMod(button, 'focused', 'yes')
                        .setMod(button, 'checked', 'yes');
                }
            })
            .liveBindTo('radio', 'focusin focusout', function(e) {
                this.setMod(
                    this.__self._getButtonByElem(e.data.domElem),
                    'focused',
                    e.type == 'focusin'? 'yes' : '');
            });

        return false;
    },

    _getButtonByElem : function(elem) {

        return elem.closest(this.buildSelector('button'));

    }

});
