/** @requires BEM */
/** @requires BEM.DOM */

(function($) {

BEM.DOM.decl({block: 'b-head-stripe', modName: 'type', modVal: 'js'}, {

    onSetMod: {
        js : function() {

            this.__base.apply(this, arguments);

            this._ajax = BEM.create('i-request_type_ajax', {
                url: 'http://yabs.yandex.ru/page/148?sids=' + Lego.params['sid'],
                callbackCtx: this
            });
            this._ajax.get({}, this._onGetData, false, this);
        }
    },
    _onGetData : function(data) {
        if ($.isEmptyObject(data)) return;
        var stripe = data.stripe[0];

        stripe.theme && (this._changeTheme(stripe.theme));
        stripe.counter && (this._generateCounter(stripe.counter));

        /* Вставляем тексты в полоску */
        this.elem('text').text(stripe.text);
        this.elem('install').attr('href', stripe.download_url).text(stripe.download_button);
        this.elem('close').attr('href', stripe.close_url).append(stripe.close_button);

        /* Выдвигаем полоску наружу */
        this.domElem.animate({ 'margin-top' : 0}, 500);
        this.setMod('state' , '');

    }

}, {

    live : false

});

})(jQuery);
