/** @requires BEM */
/** @requires BEM.DOM */

(function($) {

BEM.DOM.decl('b-head-stripe', {

    onSetMod : {
        js : function() {
            this.bindTo('leftclick', this._install);

            this.bindTo('close', 'leftclick', function(e) {
                this._close(e);
            });

            var theme = this.getMod('theme') || this.elem('theme').text(),
                counterSrc = this.elem('counter').text();

            theme && (this._changeTheme(theme));
            counterSrc && (this._generateCounter(counterSrc));

        }
    },

    _install : function(e) {
        e.preventDefault();

        var installUrl = this.elem('install').attr('href');
        installUrl && (window.location = installUrl);
    },

    _close : function(e) {
        e.preventDefault();
        e.stopPropagation();

        new Image().src = this.elem('close').attr('href');

        this.domElem.animate({ 'margin-top': '-20px'}, 500);
        this.setMod('state', 'closed');
    },

    _changeTheme : function(theme) {
        if (!theme) return;

        var _this = this;
        /* Грузим стили нужной темы */
        BEM.blocks['i-loader'].load(
            'b-head-stripe_theme_' + theme,
            Lego.params['lego-static-host'] + '/blocks/b-head-stripe/_theme/b-head-stripe_theme_' + theme + '.bembundle.js',
            function() {
                _this.setMod('theme', theme);
            }
        );
    },

    _generateCounter : function (counterSrc){

        new Image().src = counterSrc;
    }

});

})(jQuery);
