<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:exsl="http://exslt.org/common"
    exclude-result-prefixes=" x lego exsl "
    extension-element-prefixes=" x exsl"
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-stripe">
    <xsl:variable name="lego:data">
        <xsl:apply-templates select="." mode="lego:data"/>
    </xsl:variable>
<div>
    <xsl:apply-templates select="." mode="lego:block-attributes"/>
    <xsl:variable name="class">
        <xsl:apply-templates select="." mode="lego:block-class-content"/>
        <xsl:apply-templates select="." mode="lego:closed-class">
            <xsl:with-param name="data" select="$lego:data"/>
        </xsl:apply-templates>
    </xsl:variable>

    <xsl:attribute name="class">
        <xsl:value-of select="$class"/>
    </xsl:attribute>

    <xsl:apply-templates select="." mode="lego:js-params"/>

    <div class="b-head-stripe__inner">
        <xsl:apply-templates select="." mode="lego:stripe-theme">
            <xsl:with-param name="data" select="$lego:data"/>
        </xsl:apply-templates>

         <xsl:apply-templates select="." mode="lego:stripe-counter">
            <xsl:with-param name="data" select="$lego:data"/>
        </xsl:apply-templates>

        <table class="b-head-stripe__layout">
            <tr>
                <td class="b-head-stripe__layout-gap-left"><i class="b-head-stripe__layout-gap"></i></td>
                <td class="b-head-stripe__layout-left"><div class="b-head-stripe__text">
                    <xsl:apply-templates select="." mode="lego:text-content">
                        <xsl:with-param name="data" select="$lego:data"/>
                    </xsl:apply-templates>
                </div></td>
                <td class="b-head-stripe__layout-center"><a class="b-head-stripe__install">
                    <xsl:attribute name="href">
                        <xsl:apply-templates select="." mode="lego:install-url">
                            <xsl:with-param name="data" select="$lego:data"/>
                        </xsl:apply-templates>
                    </xsl:attribute>
                    <xsl:apply-templates select="." mode="lego:install-content">
                        <xsl:with-param name="data" select="$lego:data"/>
                    </xsl:apply-templates>
                </a></td>
                <td class="b-head-stripe__layout-right"><a class="b-head-stripe__close">
                    <xsl:attribute name="href">
                        <xsl:apply-templates select="." mode="lego:close-url">
                            <xsl:with-param name="data" select="$lego:data"/>
                        </xsl:apply-templates>
                    </xsl:attribute>
                    <img class="b-ico" src="//yastatic.net/lego/_/La6qi18Z8LwgnZdsAr1qy1GwCwo.gif" alt="X" />
                    <xsl:apply-templates select="." mode="lego:close-content">
                        <xsl:with-param name="data" select="$lego:data"/>
                    </xsl:apply-templates>
                </a></td>
                <td class="b-head-stripe__layout-gap-right"><i class="b-head-stripe__layout-gap"></i></td>
            </tr>
        </table>
    </div>
</div>
</xsl:template>

<xsl:template match="lego:b-head-stripe" mode="lego:closed-class">
    <xsl:param name="data"/>
    <xsl:if test="not(exsl:node-set($data)/theme)">
        <xsl:text> b-head-stripe_state_closed</xsl:text>
    </xsl:if>
</xsl:template>

<xsl:template match="lego:b-head-stripe[data]" mode="lego:closed-class">
    <xsl:if test="not(data/theme)">
        <xsl:text> b-head-stripe_state_closed</xsl:text>
    </xsl:if>
</xsl:template>

<xsl:template match="lego:b-head-stripe[data and not(@lego:theme)]" mode="lego:block-class-content">
    <xsl:apply-imports/>
    <xsl:text> b-head-stripe_theme_</xsl:text>
    <xsl:value-of select="data/theme"/>
</xsl:template>

<xsl:template match="lego:b-head-stripe" mode="lego:stripe-theme"/>
<xsl:template match="lego:b-head-stripe[not(data) and not(@lego:theme)]" mode="lego:stripe-theme">
    <xsl:param name="data"/>
    <div class="b-head-stripe__theme">
        <xsl:value-of select="exsl:node-set($data)/theme"/>
    </div>
</xsl:template>

<xsl:template match="lego:b-head-stripe" mode="lego:stripe-counter"/>
<xsl:template match="lego:b-head-stripe[not(data)]" mode="lego:stripe-counter">
    <xsl:param name="data"/>
    <div class="b-head-stripe__counter">
        <xsl:value-of select="exsl:node-set($data)/counter"/>
    </div>
</xsl:template>

<xsl:template match="lego:b-head-stripe" mode="lego:data">
    <xsl:variable name="lego:head-stripe-handle">
        <xsl:text>http://yabs.yandex.ru/page/150?sids=</xsl:text>
        <xsl:value-of select="lego:params()/lego:sid"/>
    </xsl:variable>
    <xsl:value-of select="x:set-state-string('lego-head-stripe-handle', $lego:head-stripe-handle)"/>
    <x:http xpointer="/banners/stripe/banner/*" proxy="yes" timeout="250" id="b-head-stripe">
        <x:method>getHttp</x:method>
        <x:param type="StateArg" as="String">lego-head-stripe-handle</x:param>
    </x:http>
</xsl:template>
<xsl:template match="lego:b-head-stripe[data]" mode="lego:data"/>

<xsl:template match="lego:b-head-stripe" mode="lego:text-content">
    <xsl:param name="data"/>
    <xsl:value-of select="exsl:node-set($data)/text"/>
</xsl:template>

<xsl:template match="lego:b-head-stripe[data]" mode="lego:text-content">
    <xsl:param name="data"/>
    <xsl:value-of select="data/text"/>
</xsl:template>

<xsl:template match="lego:b-head-stripe" mode="lego:install-content">
    <xsl:param name="data"/>
    <xsl:value-of select="exsl:node-set($data)/download_button"/>
</xsl:template>

<xsl:template match="lego:b-head-stripe[data]" mode="lego:install-content">
    <xsl:param name="data"/>
    <xsl:value-of select="data/download_button"/>
</xsl:template>

<xsl:template match="lego:b-head-stripe" mode="lego:install-url">
    <xsl:param name="data"/>
    <xsl:value-of select="exsl:node-set($data)/download_url"/>
</xsl:template>

<xsl:template match="lego:b-head-stripe[data]" mode="lego:install-url">
    <xsl:param name="data"/>
    <xsl:value-of select="data/download_url"/>
</xsl:template>

<xsl:template match="lego:b-head-stripe[data]" mode="lego:close-content">
    <xsl:param name="data"/>
    <xsl:value-of select="data/close_button"/>
</xsl:template>

<xsl:template match="lego:b-head-stripe" mode="lego:close-content">
    <xsl:param name="data"/>
    <xsl:value-of select="exsl:node-set($data)/close_button"/>
</xsl:template>

<xsl:template match="lego:b-head-stripe" mode="lego:close-url">
    <xsl:param name="data"/>
    <xsl:value-of select="exsl:node-set($data)/close_url"/>
</xsl:template>

<xsl:template match="lego:b-head-stripe[data]" mode="lego:close-url">
    <xsl:param name="data"/>
    <xsl:value-of select="data/close_url"/>
</xsl:template>

</xsl:stylesheet>

