<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    extension-element-prefixes=" x "
    exclude-result-prefixes=" x "
    version="1.0">

    <xsl:output
        encoding="UTF-8"
        method="text"
        indent="no"
        media-type="text/javascript"
        omit-xml-declaration="yes"
        />

    <xsl:template match="/data">
        <xsl:value-of select="x:http-header-out('Content-Type', 'text/javascript; charset=UTF-8')"/>
        <xsl:text>{</xsl:text>
            <xsl:apply-templates select="*"/>
        <xsl:text>}</xsl:text>
    </xsl:template>

    <xsl:template match="/data/*">
        <xsl:if test="position() != 1">,</xsl:if>
        <xsl:value-of select="x:json-quote(name())"/>
        <xsl:text>:</xsl:text>
        <xsl:value-of select="x:json-quote(.)"/>
    </xsl:template>

</xsl:stylesheet>
