/**
 * Создаёт пример блока, основываясь на файлах
 */

var fs = require('fs'),
    exec = require('child_process').exec,
    path = require('path'),
    lego = new (require('../../../tools/lego').Lego)(process.argv[2]),
    util = require('../../../tools/util');

var examplesPath = 'blocks/b-head-stripe/examples/';

/* Сгенерировать пример со всеми полосками из модификатора theme */

var xml = '<?xml version="1.0" encoding="utf-8"?>\n' +
    '<!-- Это автоматически сгенеренный файл. Не редактируйте его самостоятельно. -->\n' +
    '<lego:page ' +
    'xmlns:lego="https://lego.yandex-team.ru" ' +
    'xmlns:xhtml="http://www.w3.org/1999/xhtml"' +
    '>';
lego.getModsFromFileSys('b-head-stripe').map(function(m){
    if (m.name != 'theme') return;
    m.vals.map(function(theme){
        if (!path.existsSync('blocks/b-head-stripe/_theme/b-head-stripe_theme_' + theme.name + '.css'))
            return;
        xml += '<lego:b-head-stripe lego:theme="' + theme.name + '">\n' +
            '<data>\n' +
                '<theme/>\n' +
                '<text>' + theme.name + '</text>\n' +
                '<download_button>Скачать</download_button>\n' +
                '<download_url>yandex.ru</download_url>\n' +
                '<close_button>Закрыть</close_button>\n' +
                '<close_url>yandex.ru</close_url>\n' +
            '</data>\n' +
        '</lego:b-head-stripe>\n';
    })
});

xml += '</lego:page>';

var exampleFileName = examplesPath + '10_auto-all_xml';

util.writeFile(exampleFileName + '.title.txt', 'Все полоски');
util.writeFile(exampleFileName + '.xml', xml);
