<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:exsl="http://exslt.org/common"
    extension-element-prefixes=" exsl "
    exclude-result-prefixes=" lego exsl "
    >

    <xsl:import href="../b-dropdowna/b-dropdowna.convert2xml.xsl"/>
    <xsl:import href="../b-popupa/b-popupa.convert2xml.xsl"/>

    <xsl:template match="lego:b-head-tabs">
        <lego:b-head-tabs>
            <xsl:apply-templates select="@*"/>
            <xsl:variable name="type">
                <xsl:apply-templates select="." mode="type"/>
            </xsl:variable>
            <xsl:apply-templates select="." mode="lego:b-head-tabs-source">
                <xsl:with-param name="type" select="$type"/>
                <xsl:with-param name="locale" select="$locale"/>
            </xsl:apply-templates>
        </lego:b-head-tabs>
    </xsl:template>

    <xsl:template match="lego:b-head-tabs" mode="type">
        <xsl:choose>
            <xsl:when test="@type | @lego:type">
                <xsl:value-of select="@type | @lego:type"/>
            </xsl:when>
            <xsl:otherwise>search-and-content</xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="lego:b-head-tabs/lego:more">
        <xsl:variable name="dropdowna" select="lego:b-dropdowna"/>
        <xsl:copy>
            <xsl:apply-templates select="exsl:node-set($dropdowna)"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="lego:b-head-tabs" mode="lego:b-head-tabs-source">
        <xsl:param name="type"/>
        <xsl:param name="locale"/>
        <xsl:apply-templates select="document(concat('b-head-tabs.xml.', $type, '.', $locale, '.xml'))/lego:b-head-tabs/*"/>
    </xsl:template>

    <xsl:template match="lego:b-head-tabs//lego:item">
        <xsl:choose>
            <xsl:when test="@service-id = $id">
                <lego:item current="" service-id="{@service-id}">
                    <xsl:apply-templates select="." mode="content"/>
                </lego:item>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy>
                    <xsl:apply-templates select="@*"/>
                    <xsl:apply-templates/>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="lego:b-head-tabs/@type"/>

</xsl:stylesheet>
