(function($, Lego){

var bHeadTabs = Lego.block['b-head-tabs'] = function(params){
    var thisHeadTabs = $(this),
        headSearch = $('.b-head-search'),
        textInput = headSearch.find('.b-search .b-form-input input:first'),
        fromServiceId = Lego.params.id,

        // текущие параметры из урла
        urlParams = unserializeUrl(document.location.search),

        // отдельно вычисляем clid для маркета
        marketClid = { www: 505, search: 521, images: 526 }[fromServiceId] || 527,

        // параметры с дефолтными значениями, которые пробрасываем если нет текста
        noSearchDefParamsMap = { market: { cvredirect: 1, clid: marketClid } },

        // параметры с дефолтными значениями, которые пробрасываем если есть текст
        searchDefParamsMap = {
                news: { rpt: 'nnews', grhow: 'clutop' },
                haber: { rpt: 'nnews2', grhow: 'clutop' },
                yaca: { rpt: 'rs2' },
                market: { cvredirect: 1, clid: marketClid },
                blogs: { ft: 'blog' }
            },

        // параметры из урла, которые нужно пробросить если нет текста
        noSearchUrlParamsMap = (function() {
            var res = {};
            $.each(
                ['news', 'yaca', 'market', 'blogs', 'maps', 'adresa', 'video', 'fotki', 'slovari', 'auto', 'images', 'music', 'www', 'aile', 'yandex', 'haber', 'gorsel'],
                function () { res[this] = ['family'] });
            return res;
        })(),

        // параметры из урла, которые нужно пробросить если есть текст
        searchUrlParamsMap = (function() {
            var res = {};
            $.each(
                ['news', 'yaca', 'market', 'blogs', 'maps', 'adresa', 'video', 'fotki', 'slovari', 'auto', 'images', 'music', 'www', 'aile', 'yandex', 'haber', 'gorsel'],
                function () { res[this] = ['noreask', 'family'] });
            return res;
        })(),

        tabs = thisHeadTabs
            .find(':not(strong)>a.b-head-tabs__link:not([href$="/all"])')
            .map(function() {
                var toServiceId = this.host.split('.')[0],
                    tabUrlParams = unserializeUrl(this.search),
                    clid = tabUrlParams.clid,
                    noSearchParams = $.param($.extend(tabUrlParams, getNoSearchParams(toServiceId, clid)), true),
                    pathname_ = this.pathname.replace(/^\/?(.*)/, '/$1'), // оригинальный `pathname` в ссылке
                    path_ = bHeadTabs.getHostToUrlMap()[toServiceId]; // пути к поиску на сервисах

                // исключаем повторяющиеся части из адреса к поиску
                path_ && pathname_.indexOf((path_.charAt(0) === '/' ? '' : '/') + path_) > -1 && (path_ = '');
                // приводим путь в ссылке к единому виду: `some/url/`
                pathname_ = pathname_.slice(1);
                if(pathname_.length) {
                    pathname_ = pathname_.replace(/\/*$/, '/');
                }

                return {
                    node: this,
                    clid: clid,
                    toServiceId: toServiceId,
                    path: path_,
                    pathname: pathname_,
                    host: this.host,
                    searchHost: bHeadTabs.getHostMap()[toServiceId], // host поиска (ипользуем, если есть текст)
                    noSearchParamsUrl: noSearchParams ? '?' + noSearchParams : '', // урл с параметрами, если нет текста
                    searchParams: $.extend(tabUrlParams, getSearchParams(toServiceId, clid)) // параметры, если есть текст
                };
            })
            .filter(function() { return typeof this.path !== 'undefined' }),


        // последнее значение поля, чтобы правильно реагировать на изменения
        lastTextValue,

        // добавляем к табам ссылку "расширенный поиск"
        advancedSearch = headSearch.find('.b-search__advanced')[0];
        if(advancedSearch) {
            var advUrlParams = unserializeUrl(advancedSearch.search),
                path = advancedSearch.pathname.replace(/^\/?(.*)/, "$1");
            advUrlParams.text = '';
            tabs.push({
                node: advancedSearch,
                clid: advUrlParams.clid,
                toServiceId: fromServiceId,
                path: '',
                pathname: path,
                host: advancedSearch.host,
                noSearchParamsUrl: '?' + $.param(advUrlParams, true),
                searchParams: advUrlParams
            });
        }

    (function() {
        var textValue = $.trim(textInput.val()) || params['default'];

        if(lastTextValue != textValue) {
            lastTextValue = textValue;

            $.each(tabs, function() {
                textValue && (this.searchParams[bHeadTabs.getSearchParamName(this.toServiceId)] = textValue);

                this.node.href = [
                    this.node.protocol + '/',
                    textValue && this.searchHost ?
                        this.searchHost :
                        this.host,
                    this.pathname + (textValue ?
                        this.path + '?' + $.param(this.searchParams, true) :
                        this.noSearchParamsUrl)
                ].join('/');
            });
        }

        setTimeout(arguments.callee, 200);
    })();

    // получить все параметры, которые нужно пробросить, если нет текста
    function getNoSearchParams(toServiceId, clid) {
        var params = noSearchDefParamsMap[toServiceId] || {};

        !params.clid && clid && (params.clid = clid);

        $.each(noSearchUrlParamsMap[toServiceId] || [], function() {
            urlParams[this] && (params[this] = urlParams[this]);
        });

        return params;
    }

    // получить все параметры, которые нужно пробросить, если есть текст
    function getSearchParams(toServiceId, clid) {
        var filterUrlParams = [].concat(searchUrlParamsMap[toServiceId]),
            toAndFrom = toServiceId + fromServiceId;

        (toAndFrom == 'imageswww' || toAndFrom == 'wwwimages') &&
            filterUrlParams.push('site');

        var params = searchDefParamsMap[toServiceId] || {};

        $.each(filterUrlParams, function() {
            urlParams[this] && (params[this] = urlParams[this]);
        });

        !params['clid'] && clid && toServiceId !== 'www' &&
            (params.clid = clid);

        return params;
    }

    // парсит параметры из урла в хэш
    function unserializeUrl(url) {
        var params = {};

        $.each(url.substr(1).split('&'), function(param) {
            var splitted = this.split('='),
                key = splitted[0],
                val = splitted[1];

            if (key)
                if(params.hasOwnProperty(key)) {
                    var vals = params[key];
                    $.isArray(vals) ?
                        vals.push(val) :
                        params[key] = [vals, val];
                } else params[key] = val;
        });

        return $.decodeURIComponent !== undefined ? unencodeFields(params) : params;
    }

    function unencodeFields(obj) {
        var fields = ['site'];
        $.each(obj, function(key, value) {
            if($.inArray(key, fields) > -1) obj[key] = $.isArray(value) ? value.map(function(v){ return $.decodeURIComponent(v) }) : $.decodeURIComponent(value);
        });
        return obj
    }
};

$.extend(bHeadTabs, {

    getHostToUrlMap: function() {
        var result = {
            www: 'yandsearch',
            market: 'search.xml',
            maps: '',
            music: '#!/search',
            video: 'search'
        };
        result.harita = result.maps;
        result.blogs = result.adresa = result.fotki = result.slovari = result.auto = result.market;
        result.news = result.yaca = result.images = result.gorsel = result.haber = result.aile = result.yandex = result.www;
        return result;
    },

    getHostMap: function() { return {} },

    getSearchParamName: function(serviceId) { return 'text' }

});

})(jQuery, window.Lego);
