<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:exsl="http://exslt.org/common"
    extension-element-prefixes="exsl"
    version="1.0">

<xsl:output method="xml" encoding="utf-8" indent="yes"/>

<lego:comments>
    USAGE: xsltproc --stringparam locale ru b-head-tabs.raw2xml.xsl b-head-tabs.raw.advertising.xml > b-head-tabs.xml.advertising.ru.xml
</lego:comments>

<xsl:param name="locale"/>

<xsl:variable name="services" select="document(concat('../i-services/common.', $locale, '.xml'))/lego:services/lego:service"/>
<xsl:variable name="messages" select="document(concat('../i-messages/messages.', $locale, '.xml'))/lego:messages/lego:message"/>

<!--
LEGO-5177 - b-head-tabs: Cписок в "еще" должен быть отсортирован по алфавиту на каждом языке
(varankinv@) хак для сортировки строк со смешанным алфавитом (латинский + всякие умляуты)
-->
<!-- ASCII -->
<xsl:variable name="_alpha">!#$%()*+,-.0123456789@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_abcdefghijklmnopqrstuvwxyz{|}~</xsl:variable>

<!-- алфавиты используемых локалей (ru, uk, en, be, az, tt, kk, tr) -->
<xsl:variable name="_alpha_ru">АБВГДЕЁЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдеёжзийклмнопрстуфхцчшщъыьэюя</xsl:variable>
<xsl:variable name="_alpha_uk">АБВГҐДЕЄЖЗИІЇЙКЛМНОПРСТУФХЦЧШЩЬЮЯабвгґдеєжзиіїйклмнопрстуфхцчшщьюя</xsl:variable>
<xsl:variable name="_alpha_en">ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz</xsl:variable>
<xsl:variable name="_alpha_be">АБВГДЕЁЖЗІЙКЛМНОПРСТУўФХЦЧШыьЭЮЯабвгдеёжзійклмнопрстуўфхцчшыьэюя</xsl:variable>
<xsl:variable name="_alpha_az">ABCÇDEƏFGĞHXIIJKQLMNOÖPRSŞTUÜVYZabcçdeəfgğhxıijkqlmnoöprsştuüvyz</xsl:variable>
<xsl:variable name="_alpha_tt">АӘБВГДЕЁЖҖЗИЙКЛМНҢОӨПРСТУҮФХҺЦЧШЩЪЫЬЭЮЯаәбвгдеёжҗзийклмнңоөпрстуүфхһцчшщъыьэюя</xsl:variable>
<xsl:variable name="_alpha_kk">АӘБВГҒДЕЁЖЗИЙКҚЛМНҢОӨПРСТУҰҮФХҺЦЧШЩъЫІьЭЮЯаәбвгғдеёжзийкқлмнңоөпрстуұүфхһцчшщъыіьэюя</xsl:variable>
<xsl:variable name="_alpha_tr">ABCÇDEFGĞHIIJKLMNOÖPRSŞTUÜVYZabcçdefgğhıijklmnoöprsştuüvyz</xsl:variable>

<xsl:template match="lego:tabs">
    <xsl:comment>
        <xsl:text> This is auto-generated file. Don't edit it! Use make.sh instead. </xsl:text>
    </xsl:comment>
    <lego:b-head-tabs>
        <xsl:apply-templates/>
    </lego:b-head-tabs>
</xsl:template>

<xsl:template match="lego:more">
    <lego:more>
        <xsl:variable name="b-dropdowna">
            <lego:b-dropdowna lego:direction="down">
                <lego:switcher>
                    <lego:b-pseudo-link lego:is-bem="yes">
                        <xsl:value-of select="$messages[@id = 'b-dropdown-more']"/>
                    </lego:b-pseudo-link>
                </lego:switcher>

                <lego:b-popupa>
                    <lego:tail/>
                    <lego:content>
                        <lego:b-menu lego:layout="vert" lego:preset="vmenu">
                            <xsl:apply-templates select="." mode="dropdowna-more"/>
                        </lego:b-menu>
                    </lego:content>
                </lego:b-popupa>
            </lego:b-dropdowna>
        </xsl:variable>
        <xsl:copy-of select="$b-dropdowna"/>
        <!-- <xsl:apply-templates select="exsl:node-set($b-dropdowna)"/> -->
    </lego:more>
</xsl:template>

<xsl:template match="lego:tab">
    <xsl:if test="@separator">
        <lego:separator/>
    </xsl:if>
    <lego:item service-id="{@id}">
        <xsl:apply-templates select="$services[@id = current()/@id][1]">
            <xsl:with-param name="url" select="@url"/>
        </xsl:apply-templates>
    </lego:item>
</xsl:template>

<xsl:template match="lego:more/lego:item">
    <lego:item>
        <xsl:apply-templates select="$services[@id = current()/@id][1]"/>
    </lego:item>
</xsl:template>

<xsl:template match="lego:service">
    <xsl:param name="url"/>
    <lego:b-link>
        <xsl:attribute name="url">
            <xsl:choose>
                <xsl:when test="$url"><xsl:value-of select="$url"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="@url"/></xsl:otherwise>
            </xsl:choose>
        </xsl:attribute>
        <xsl:apply-templates select="." mode="content"/>
    </lego:b-link>
</xsl:template>

<xsl:template match="lego:service" mode="content">
    <xsl:value-of select="."/>
</xsl:template>

<xsl:template match="lego:service[@id = 'mobile']" mode="content">
    <xsl:choose>
        <xsl:when test="$locale = 'ru'">Для мобильного</xsl:when>
        <xsl:when test="$locale = 'en'">Mobile</xsl:when>
        <xsl:when test="$locale = 'tr'">Mobil</xsl:when>
        <xsl:when test="$locale = 'kk'">Мобильдік телефон үшін</xsl:when>
        <xsl:when test="$locale = 'tt'">Мобильный өчен</xsl:when>
        <xsl:when test="$locale = 'uk'">Для мобільного</xsl:when>
        <xsl:when test="$locale = 'az'">Mobil telefon üçün</xsl:when>
        <xsl:when test="$locale = 'be'">Для мабiльнага</xsl:when>
    </xsl:choose>
</xsl:template>

<xsl:template match="lego:more" mode="dropdowna-more">
    <xsl:variable name="more-tabs">
        <xsl:copy>
            <xsl:apply-templates/>
        </xsl:copy>
    </xsl:variable>
    <xsl:apply-templates select="exsl:node-set($more-tabs)" mode="dropdowna-more-sort"/>
</xsl:template>

<xsl:template match="lego:more[@order = 'raw']" mode="dropdowna-more">
    <xsl:apply-templates/>
</xsl:template>

<xsl:template match="lego:more" mode="dropdowna-more-sort">
    <xsl:variable name="_alpha_locale">
    	<xsl:choose>
            <xsl:when test="$locale = 'ru'"><xsl:copy-of select="$_alpha_ru"/></xsl:when>
            <xsl:when test="$locale = 'en'"><xsl:copy-of select="$_alpha_en"/></xsl:when>
            <xsl:when test="$locale = 'tr'"><xsl:copy-of select="$_alpha_tr"/></xsl:when>
            <xsl:when test="$locale = 'kk'"><xsl:copy-of select="$_alpha_kk"/></xsl:when>
            <xsl:when test="$locale = 'tt'"><xsl:copy-of select="$_alpha_tt"/></xsl:when>
            <xsl:when test="$locale = 'uk'"><xsl:copy-of select="$_alpha_uk"/></xsl:when>
            <xsl:when test="$locale = 'az'"><xsl:copy-of select="$_alpha_az"/></xsl:when>
            <xsl:when test="$locale = 'be'"><xsl:copy-of select="$_alpha_be"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$_alpha_en"/></xsl:otherwise>
        </xsl:choose>
    </xsl:variable>

    <xsl:apply-templates select="lego:item[not(preceding-sibling::lego:separator)]" mode="dropdowna-more-sort">
        <xsl:sort select="translate(lego:b-link, $_alpha_locale, $_alpha)" data-type="text"/>
    </xsl:apply-templates>

    <xsl:copy-of select="lego:separator"/>
    <xsl:copy-of select="lego:item[preceding-sibling::lego:separator]"/>
</xsl:template>

<xsl:template match="lego:more/lego:item" mode="dropdowna-more-sort">
    <xsl:copy-of select="."/>
</xsl:template>

</xsl:stylesheet>

