<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    extension-element-prefixes=" x "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-tabs">
    <xsl:comment>noindex</xsl:comment>
    <table>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>
        <xsl:apply-templates select="." mode="lego:wai"/>
        <tr>
            <xsl:apply-templates select="." mode="lego:content"/>
        </tr>
        <xsl:apply-templates select="@lego:theme"/>
    </table>
    <xsl:comment>/noindex</xsl:comment>
</xsl:template>

<xsl:template match="lego:b-head-tabs" mode="lego:wai">
    <xsl:attribute name="role">navigate</xsl:attribute>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-tabs" mode="lego:block-class-js">
    <xsl:text> g-js</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-tabs" mode="lego:js-params-content">
    <xsl:apply-imports/>
    <xsl:variable name="default">
        <xsl:apply-templates select="." mode="lego:param-default"/>
    </xsl:variable>
    <xsl:text>,'default':</xsl:text><xsl:value-of select="x:js-quote($default)"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-tabs" mode="lego:param-default"/>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-tabs" mode="lego:content">
    <xsl:apply-templates select="lego:item | lego:more"/>
</xsl:template>

<xsl:template match="lego:b-head-tabs/lego:item" mode="lego:class-content">
    <xsl:text>b-head-tabs__tab</xsl:text>
</xsl:template>

<xsl:template match="lego:b-head-tabs/lego:more">
    <td class="b-head-tabs__tab b-head-tabs__more">
        <xsl:apply-templates select="lego:b-dropdowna"/>
    </td>
</xsl:template>

<xsl:template match="lego:b-head-tabs//lego:b-link" mode="lego:class-content">
    <xsl:text>b-head-tabs__link</xsl:text>
</xsl:template>

<xsl:template match="lego:b-head-tabs//lego:b-link" mode="lego:counter-content">
    <xsl:value-of select="$lego:id"/>.tabs.<xsl:value-of select="ancestor::lego:item/@service-id"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-tabs//lego:item[@current and lego:params()/lego:index]/lego:b-link">
    <xsl:apply-templates select="." mode="lego:content"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="/" mode="lego:default-params">
    <xsl:apply-imports/>
    <xsl:if test="$lego:user-params/lego:gemius/lego:region and not($lego:user-params/lego:country)">
        <lego:country>
            <xsl:value-of select="$lego:user-params/lego:gemius/lego:region"/>
        </lego:country>
    </xsl:if>
</xsl:template>

<xsl:template match="lego:b-head-tabs//lego:item[@service-id = 'music']" mode="lego:b-menu__layout-cell"/>

<xsl:template match="lego:b-head-tabs//lego:item[@service-id = 'music' and not(lego:params()/lego:country)]" mode="lego:b-menu__layout-cell">
    <xsl:variable name="foreign">
        <!-- Россия -->
        <x:geo-block xpointer="/result/@code[. = '0']">
            <x:method>isIn</x:method>
            <x:param type="String">225</x:param>
        </x:geo-block>
        <!-- Украина -->
        <x:geo-block xpointer="/result/@code[. = '0']">
            <x:method>isIn</x:method>
            <x:param type="String">187</x:param>
        </x:geo-block>
        <!-- Беларусь -->
        <x:geo-block xpointer="/result/@code[. = '0']">
            <x:method>isIn</x:method>
            <x:param type="String">149</x:param>
        </x:geo-block>
        <!-- Казахстан -->
        <x:geo-block xpointer="/result/@code[. = '0']">
            <x:method>isIn</x:method>
            <x:param type="String">159</x:param>
        </x:geo-block>
    </xsl:variable>
    <xsl:if test="$foreign = 0">
        <xsl:apply-imports/>
    </xsl:if>
</xsl:template>

<xsl:template match="lego:b-head-tabs//lego:item[@service-id = 'music' and (
        lego:params()/lego:country = '187' or
        lego:params()/lego:country = '149' or
        lego:params()/lego:country = '159' or
        lego:params()/lego:country = '225'
    )]" mode="lego:b-menu__layout-cell">
    <xsl:apply-imports/>
</xsl:template>

</xsl:stylesheet>

