(function($, Lego){

var bHeadUser = Lego.block['b-head-user'] = function(){
    var thisBlock = $(this);

    if (Lego.params.login != '' || Lego.params.displayName) {
        $.getJSON(
            bHeadUser.getApiUrl(),
            {
                locale : Lego.params.locale,
                login : 'yes',
                'current-login' : Lego.params.login,
                yu : Lego.getCookie('yandexuid')
            },
            function(data){
                bHeadUser.buildHtml(data, thisBlock);
            }
        );
    }

};

bHeadUser.buildHtml = function(data, thisBlock) {
    if (!data || !data.services) return;
    var social = data.displayName && data.displayName.social,
        login = $('<div/>').text(bHeadUser.getUserLogin(data)).html(),
        user = social?
            '<b class="b-user b-user_social_yes">' +
                '<span class="b-user__provider-ico" style="background:url(https://yastatic.net/social/current/icons/16/' + social.provider + '.png)"></span>' + login +
            '</b>' :
            '<b class="b-user"><b class="b-user__first-letter">' + login.substring(0, 1) + '</b>' + login.substring(1) + '</b>',
        link = '<a class="b-pseudo-link b-pseudo-link_is-bem_yes i-bem" onclick="return {\'b-pseudo-link\':{name:\'b-pseudo-link\'}}"' +
            (!social && thisBlock.hasClass('b-head-user_type_com')?
                '' :
                ' href="' + (social? Lego.params['social-host'] : 'http://i.yandex.ru') + '"'
            ) + '>' + user + '</a>',
        html =  '<div class="b-dropdowna b-dropdowna_is-bem_yes i-bem" onclick="return {\'b-dropdowna\':{name:\'b-dropdowna\'}}">' +
                    '<span class="b-dropdowna__switcher">' +
                        link +
                    '</span>' +
                    '<div class="i-popup i-popup_autoclosable_yes i-popup_is-bem_yes i-bem" ' +
                    'onclick="return {\'i-popup\':{name:\'i-popup\'}}">' +
                        '<div class="i-popup__content">' +
                            '<div class="i-popup__under b-popupa__under"></div>' +
                            '<div class="b-popupa b-popupa_theme_ffffff b-popupa_direction_down b-popupa_is-bem_yes ' +
                                'i-bem b-dropdowna__popup" ' +
                                'onclick="return {\'b-popupa\':{name:\'b-popupa\'}}">' +
                                    '<i class="b-popupa__shadow"></i>' +
                                    '<i class="b-popupa__tail">' +
                                        '<i class="b-popupa__tail-i"></i>' +
                                    '</i>' +
                                    '<table cellpadding="0" cellspasing="0" class="b-popupa__wrap">' +
                                        '<tr>' +
                                            '<td class="b-popupa__wrap-cell">' +
                                                '<div class="b-popupa__content">' +
                                                    '<div class="b-menu b-menu_layout_vert b-menu_preset_vmenu">' +
                                                        '<ul class="b-menu__layout-vert">';

    social && thisBlock.addClass('b-head-user_social_yes');

    $.each(data.services, function(i){
    html += '<li class="b-menu__layout-vert-cell' +
                (i == 0? ' b-menu__layout-vert-cell_position_first' : '') +
                '">' +
                '<div class="b-menu__item">';
        if (Lego.params.id == this.id && Lego.params.index) {
            html += '<strong>' + this.title + '</strong>';
        } else {
            html += '<a ' +
                'class="b-link b-head-user__link" ' +
                'href="' + this.url + '" ' +
                'onmousedown="Lego.ch(\'' + Lego.params.id + '.login.myservices.' + this.id + '\',this)">' +
                    this.title +
                '</a>';
        }
        html += '</div></li>';
    });

    if (data.services.length)
        html += '<li class="b-menu__layout-vert-separator"><i class="b-menu__separator"></i></li>';

    html += bHeadUser.getUserItems(data, thisBlock);

    html += '</ul></div></div></td></tr></table></div></div></div></div>';

    thisBlock.find('.b-user').replaceWith(html);
    BEM.DOM.init(thisBlock);
};

bHeadUser.getApiUrl = function(){ return Lego.params['pass-host'] + '/services?callback=?' };

bHeadUser.getUserItems = function(data){

    var services = data.displayName && data.displayName.social? [
            {
                name : Lego.message('b-head-userinfo.user:profile', 'Мои профили'),
                url : Lego.params['social-host']
            }
        ] : [
            {
                name : Lego.message('b-head-userinfo.user:passport', 'Паспорт'),
                url : Lego.params['passport-host']
            },
            {
                name : Lego.message('b-head-userinfo.user:change-password', 'Сменить пароль'),
                url : Lego.params['passport-host'] + '/passport?mode=changepass' +
                    '&retpath=' + encodeURIComponent(Lego.params['retpath']) + '/'
            }
        ];

    var html = '';

    $.each(services, function(i, service) {
        html += '<li class="b-menu__layout-vert-cell' +
                    (i == services.length-1? ' b-menu__layout-vert-cell_position_last' : '') +
                    '">' +
                    '<div class="b-menu__item">' +
                '<a class="b-link b-head-user__link" href="' + service.url + '">' +
                    service.name +
                '</a>' +
                    '</div>' +
            '</li>';
    });
    return html;
};

bHeadUser.getUserLogin = function(data){
    return Lego.params.displayName && Lego.params.displayName.social && Lego.params.displayName.name ||
        data.displayName && data.displayName.name ||
        Lego.params.login ||
        data.login;
};


})(jQuery, window.Lego);
