<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-user">
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </div>
</xsl:template>

<xsl:template match="lego:b-head-user" mode="lego:content">
    <xsl:variable name="url">
        <xsl:apply-templates select="." mode="lego:url-content"/>
    </xsl:variable>
    <xsl:apply-templates select="lego:b-wc-status"/>

    <xsl:call-template name="lego:apply">
        <xsl:with-param name="content">
            <lego:b-user url="{$url}" counter="{concat($lego:id, '.login.user')}">
                <xsl:if test="lego:params()/lego:display-name/social">
                    <xsl:attribute name="lego:social">yes</xsl:attribute>
                    <xsl:attribute name="lego:provider">
                        <xsl:value-of select="lego:params()/lego:display-name/social/provider"/>
                    </xsl:attribute>
                </xsl:if>
                <xsl:value-of select="lego:user-name()"/>
            </lego:b-user>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template match="lego:b-head-user" mode="lego:url-content">
    <xsl:text>http://i.yandex.ru</xsl:text>
</xsl:template>

<xsl:template match="lego:b-head-user[lego:params()/lego:display-name/social]" mode="lego:url-content">
    <xsl:value-of select="lego:params()/lego:social-host"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-user" mode="lego:block-class-js">
    <xsl:text> g-js</xsl:text>
</xsl:template>

</xsl:stylesheet>

