<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-userinfo/lego:region" mode="lego:add">
    <xsl:variable name="content">
        <xsl:choose>
            <xsl:when test="normalize-space(.) = ''">
                <xsl:value-of select="$lego:params/lego:b-head-userinfo/lego:region"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="."/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:value-of select="concat(': ', $content)"/>
</xsl:template>

<xsl:template match="lego:b-head-userinfo/lego:region" mode="lego:content">
    <xsl:value-of select="lego:message('b-head-userinfo-region', 'Регион')"/>
</xsl:template>

<xsl:template match="lego:b-head-userinfo/lego:region" mode="lego:url-content">
    <xsl:apply-imports />
    <xsl:if test="$lego:params/lego:retpath">
        <xsl:text>?retpath=</xsl:text><xsl:value-of select="x:urlencode('utf-8', $lego:params/lego:retpath)"/>
    </xsl:if>
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>

