<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-hmenu">
    <table>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <tr>
            <xsl:apply-templates select="." mode="lego:content"/>
        </tr>
    </table>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-hmenu/lego:item[@current]" mode="lego:current">
    <div class="current">
        <xsl:apply-imports/>
    </div>
</xsl:template>

<xsl:template match="lego:b-hmenu[@lego:theme = 'round']/lego:item[@current]" mode="lego:current">
    <div class="current">
        <xsl:call-template name="lego:b-round-side">
            <xsl:with-param name="side" select="'t'"/>
            <xsl:with-param name="radius" select="10"/>
            <xsl:with-param name="left" select="true()"/>
            <xsl:with-param name="right" select="true()"/>
        </xsl:call-template>
        <xsl:apply-imports/>
        <xsl:call-template name="lego:b-round-side">
            <xsl:with-param name="side" select="'b'"/>
            <xsl:with-param name="radius" select="10"/>
            <xsl:with-param name="left" select="true()"/>
            <xsl:with-param name="right" select="true()"/>
        </xsl:call-template>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-hmenu/lego:item" mode="lego:class-content">
    <xsl:apply-imports/>
    <xsl:text> item</xsl:text>
</xsl:template>

<xsl:template match="lego:b-hmenu/lego:item[not(preceding-sibling::lego:item)]" mode="lego:class-content">
    <xsl:apply-imports/>
    <xsl:text> item first</xsl:text>
</xsl:template>

<xsl:template match="lego:b-hmenu/lego:item[not(following-sibling::lego:item)]" mode="lego:class-content">
    <xsl:apply-imports/>
    <xsl:text> item last</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-hmenu/lego:gap">
    <td class="gap"></td>
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>

