<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-input">
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates/>
    </div>
</xsl:template>

<xsl:template match="lego:b-input/lego:text">
    <input>
        <xsl:apply-templates select="ancestor::lego:b-input" mode="lego:input-attributes"/>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
    </input>
</xsl:template>

<xsl:template match="lego:b-input/lego:text[@lego:type='textarea']">
    <textarea>
        <xsl:apply-templates select="ancestor::lego:b-input" mode="lego:input-attributes"/>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
    </textarea>
</xsl:template>

<xsl:template match="lego:b-input[@disabled = 'disabled']" mode="lego:input-attributes">
    <xsl:apply-imports/>
    <xsl:attribute name="disabled">disabled</xsl:attribute>
</xsl:template>

<!--<xsl:template match="lego:b-input/lego:b-hint-input">
    <label>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates/>
    </label>
</xsl:template>-->

</xsl:stylesheet>
