<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:exsl="http://exslt.org/common"
    extension-element-prefixes=" exsl "
    exclude-result-prefixes=" lego exsl "
    >

    <xsl:import href="../i-bem/i-bem.convert2xml.xsl"/>
    <xsl:import href="../b-dropdowna/b-dropdowna.convert2xml.xsl"/>
    <xsl:import href="../b-popupa/b-popupa.convert2xml.xsl"/>

    <xsl:template match="lego:b-keyboard-loader">
        <lego:declaration>
            <xsl:variable name="i-bem">
                <lego:i-bem>
                    <lego:dom/>
                </lego:i-bem>
            </xsl:variable>
            <xsl:apply-templates select="exsl:node-set($i-bem)"/>
            <xsl:variable name="b-dropdowna">
                <lego:b-dropdowna lego:direction="up">
                    <lego:switcher>
                        <lego:b-pseudo-link lego:is-bem="yes"/>
                    </lego:switcher>
                    <lego:b-popupa>
                        <lego:tail/>
                        <lego:content>
                            <lego:b-menu lego:layout="vert" lego:preset="vmenu" lego:is-bem="yes">
                                <lego:item/>
                            </lego:b-menu>
                        </lego:content>
                    </lego:b-popupa>
                </lego:b-dropdowna>
            </xsl:variable>
            <xsl:apply-templates select="exsl:node-set($b-dropdowna)"/>
        </lego:declaration>
        <xsl:copy>
            <xsl:attribute name="lego:dropdowna">yes</xsl:attribute>
            <xsl:copy-of select="@*"/>
            <!-- копируем ноды -->
            <xsl:apply-templates select="*"/>
            <!-- копируем или вставляем только текст -->
            <xsl:apply-templates select="." mode="lego:content"/>
            <lego:progress/>
            <lego:g-hidden/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="lego:b-keyboard-loader/lego:flag">
        <xsl:copy-of select="."/>
        <lego:declaration>
            <lego:b-ico/>
        </lego:declaration>
    </xsl:template>

    <xsl:template match="lego:b-keyboard-loader" mode="lego:content">
        <xsl:value-of select="$messages[@id = 'b-keyboard-loader:keyboard']"/>
    </xsl:template>

    <xsl:template match="lego:b-keyboard-loader[ancestor::lego:b-search]" mode="lego:content">
        <xsl:value-of select="."/>
    </xsl:template>

</xsl:stylesheet>
