/**
 * Загрузчик виртуальной клавиатуры
 *
 * Отправляет на window события:
 *   - keyboardOpened.lego: клавиатура открылась
 *   - keyboardClosed.lego: клавиатура закрылась
 *
 * Слушает на window события:
 *   - keyboardClose.lego: открыть клавиатуру
 *   - keyboardOpen.lego: закрыть клавиатуру
 *   - keyboardChangeLang.lego: изменить язык клавиатуры
 */

(function($, Lego) {

    /**
     * @param {Object} [params] Параметры.
     * @param {Boolean} [params.autoLoad=false] Сразу открывать клавиатуру.
     * @param {Boolean} [params.storeState=true] Сохранять в window.name факт открытия клавиатуры и последний выбранный язык.
     */
    Lego.block['b-keyboard-loader'] = function(params) {
        var $body = $(document.body),
            $window = $(window),
            targetElem = this,
            lng;

        targetElem.click(function(e) {
            e.preventDefault();

            var $this = $(this),
                defaultLang = (this.className.match(/b-keyboard-loader_lang_(\w+)/) || ['', ''])[1] || Lego.params.locale;
                switch(defaultLang) {
                    case 'uk':
                        defaultLang = 'ua'
                        break
                    case 'kk':
                        defaultLang = 'kz'
                        break
                    case 'be':
                        defaultLang = 'by'
                        break
                }

            var isDropdowna = $this.hasClass('b-keyboard-loader_dropdowna_yes');

            if (!$body.find('.b-keyboard')[0]) {
                var blocksUrl = Lego.params['lego-static-host'] + (Lego.params['lego-static-host'] == '/' ? '' : '/') + 'blocks/',
                    jsFiles = (isDropdowna ? [
                        blocksUrl + 'b-keyboard/_keyboard.js'
                    ] : [
                        blocksUrl + 'b-keyboard-popup/_b-keyboard-popup.js',
                        blocksUrl + 'b-keyboard/_b-keyboard.js',
                        blocksUrl + 'b-dropdown/_b-dropdown.js'
                    ]),
                    cssPostfix = $.browser.msie && ((!document.documentMode) || (document.documentMode < 9)) ? '.ie' : '',
                    cssFiles = [
                        blocksUrl + 'b-keyboard/_keyboard' + cssPostfix +'.css'
                    ];

                $this.append('<i class="b-keyboard-loader__progress"/>');

                $.xLazyLoader({
                    name: 'b-keyboard',
                    js: jsFiles,
                    css: cssFiles,
                    success: function() {
                        // Создаем b-keyboard-popup
                        Lego.block['b-keyboard-popup']({lang: defaultLang, isDropdowna: isDropdowna});
                        // Этот блок b-keyboard - временный, он нужен только для того, чтобы можно было вызвать Lego.blockInit
//                        if ()
                        $body.append('<div class="b-keyboard' + (isDropdowna ? ' b-keyboard-loader_dropdowna_yes' : '') + ' g-js" onclick="return {name: \'b-keyboard\', lang: \'' + defaultLang + '\'};"></div>');
                        Lego.blockInit($body, '.b-keyboard');
                        $this.find('.b-keyboard-loader__progress').remove();
                        $window.trigger('keyboardOpened.lego', { afterLoad : true });
                    }
                });
            } else {
                keyboardClose();
            }
        });

        /**
         *
         * @param {Event} [e]
         */
        function keyboardClose(e) {
            // если e != undefined, то вызов пришел из события keyboardClose, поэтому принудительно закрываем клавиатуру
            var method = e ? 'addClass' : 'toggleClass',
                $popup = $body.find('.b-keyboard-popup');

            if ($popup.length) {
                $body.find('.b-keyboard-popup__gap')[method]('g-hidden');
                if ($body.find('.b-keyboard-popup')[method]('g-hidden').hasClass('g-hidden')) {
                    // оповещение о закрытии клавиатуры
                    $window.trigger('keyboardClosed');
                    $(document).trigger('popupsClose.lego');
                } else {
                    // оповещение об открытии клавиатуры
                    $window.trigger('keyboardOpened.lego');
                }
                //сбрасываем статус видимости b-keyboard-popup
                $popup.data('isHidden', false);
            }
        }

        // Keyboard API
        $window
            // событие для открытия клавиатуры
            .bind('keyboardOpen.lego', function() {
                targetElem.click();
            })
            // событие для закрытия клавиатуры
            .bind('keyboardClose.lego', keyboardClose);

        params['for'] && $window.bind('keyboardOpened.lego', function(e, data) {
            !(data && data.afterLoad && params.autoLoad) && $(params['for']).focus();
        });

        $window.bind('keyboardLangChanged.lego keyboardSetLang.lego', function(e, lang) {
            var $img = targetElem.find('.b-keyboard-loader__flag');

            if ($img[0]) {
                if (lang === 'tt') {
                    lang = 'ru';
                }

                $img.attr('src', $img.attr('src').replace(/[a-z]+\.png$/, lang + '.png'));
            }
        });

        params.storeState = params.storeState !== false;

        if (params.storeState) {
            $window
                .bind('keyboardOpened.lego', function() {
                    winNameSet('keyboard_state', 'open');

                    var lng = winNameGet('keyboard_lang');
                    if (lng) {
                        $(window).trigger('keyboardSetLang.lego', lng);
                    }
                })
                .bind('keyboardClosed.lego', function() {
                    winNameSet('keyboard_state', 'close');
                })
                .bind('keyboardLangChanged.lego', function(e, lang) {
                    winNameSet('keyboard_lang', lang);
                });
        }

        // автооткрытие клавиатуры
        (params.autoLoad = params.autoLoad || (params.storeState && winNameGet('keyboard_state') == 'open')) &&
            targetElem.click();

        var statsSubmitted;

        function sumbitStats() {
            if (statsSubmitted)
                return;

            Lego.cp(0, 70873, Lego.params.id + '.' + (params.autoLoad ? 'auto' : 'manual'));
            statsSubmitted = true;
        }

        $window.bind('keyboardOpened.lego', function(){
            sumbitStats();
        });

        function winNameGet(name) {
            return _winNameGetData()[name];
        }

        function _winNameGetData() {
            var data = {};

            $.each(window.name.split('&'), function(){
                if (this.toString()) {
                    var vars = this.split('=');
                    data[vars[0]] = vars[1];
                }
            });

            return data;
        }

        function winNameSet(name, value) {
            var data = _winNameGetData(),
                newdata = [];

            data[name] = value;

            $.each(data, function(name, value){
                newdata.push(name + '=' + value);
            });

            window.name = newdata.join('&');
        }
    };

})(jQuery, window.Lego);

include('jquery.xLazyLoader.js');
