<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-keyboard-loader">
    <span>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </span>
</xsl:template>

<xsl:template match="lego:b-keyboard-loader" mode="lego:block-class-js">
    <xsl:text> g-js</xsl:text>
</xsl:template>

<xsl:template match="lego:b-keyboard-loader" mode="lego:js-params-content">
    <xsl:apply-imports/>
    <xsl:if test="@for">
        <xsl:value-of select="concat(',', x:js-quote('for'), ':', x:js-quote(@for))"/>
    </xsl:if>
    <xsl:if test="@autoload = 'yes'">,autoLoad:true</xsl:if>
</xsl:template>

<xsl:template match="lego:b-keyboard-loader" mode="lego:content">
    <xsl:call-template name="lego:apply">
        <xsl:with-param name="content">
            <lego:b-pseudo-link>
                <xsl:copy-of select="normalize-space(.)"/>
            </lego:b-pseudo-link>
        </xsl:with-param>
    </xsl:call-template>
    <xsl:apply-templates select="lego:flag"/>
</xsl:template>

<!--Перенести в отдельный файл-->
<xsl:template match="lego:b-keyboard-loader/lego:flag">
    <xsl:call-template name="lego:apply">
        <xsl:with-param name="content">
            <lego:b-ico
                src="{concat($lego:lego-static-host, '/blocks/b-country-flag/_size-16/b-country-flag_size-16_', ../@lego:lang, '.png')}"
                class="{concat('', lego:name(.))}"
                />
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

</xsl:stylesheet>
