/**
 * Popup-контейнер для виртуальной клавиатуры
 */
(function($, Lego) {

    Lego.block['b-keyboard-popup'] = function(params) {
        var thisElems = $(
                '<div class="b-keyboard-popup__gap"/>' +
                '<div class="b-keyboard-popup">' +
                    '<div class="b-keyboard-popup__bar">' +
                        '<a class="b-keyboard-popup__bar-link b-keyboard-popup__close" href="#">' +
                        '</a>' +
                    '</div>' +
                    '<div class="b-keyboard' + ($(this).hasClass('b-keyboard-popup_dropdowna_yes') || params.isDropdowna ? ' b-keyboard_dropdowna_yes' : '') + ' g-js" ' +
                        'onclick="return {name: \'b-keyboard\', fake: false, lang: \'' + params.lang + '\'};"/>' +
                '</div>').appendTo('body'),
            thisPopup = thisElems.filter('.b-keyboard-popup'),
            thisPopupGap = thisElems.filter('.b-keyboard-popup__gap'),

            hidden = function(value) {
                if (typeof value !== "undefined") thisPopup.data('isHidden', value);
                else return thisPopup.data('isHidden');
            },

            hide = function() {
                if(hidden()) return;

                thisElems.addClass('g-hidden');
                $(window).trigger('keyboardClosed.lego');

                hidden(true);
            };

        $(document).bind('popupsClose.lego', function(e, d) {
            // не закрываем клавиатуру, если событие вызвано внутренней нодой
            (hidden() || (d && d.source && $.contains(thisPopup[0], d.source))) || hide();
        });

        var lastFocused, needsFocusRestore;

        thisElems.find('.b-keyboard-popup__close').mousedown(function(e) {
            if (e.originalEvent && e.originalEvent.preventDefault) {
                needsFocusRestore = false;
                e.preventDefault();
            } else {
                // IE < 9
                needsFocusRestore = true;
                lastFocused = $(document.activeElement);
                lastFocused.saveCaretPos();
            }
            return false;
        }).click(function() {
            hide();
            needsFocusRestore && lastFocused.focus().setCaretPos();
        });
    };

})(jQuery, window.Lego);
