(function(oldLangItems) {

    Lego.block['b-keyboard'].Keyboard.prototype.langItems = function() {
        if (!this.elem.hasClass('b-keyboard_dropdowna_yes'))
            return oldLangItems.apply(this, arguments);

        var curLang = this.elem.data('lang').id,
            langs = ['by', 'en', 'fr', 'de', 'it', 'kz', 'es', 'ru', 'tt', 'tr', 'ua'],
            langIndex = $.inArray(Lego.params.locale, langs),
            items = '';

        langIndex != -1 && langs.unshift(langs.splice(langIndex, 1)[0]);

        for (var i = 0; i < langs.length; i++) {
            var lang = langs[i],
                langLabel = Lego.block['b-keyboard'].lang[lang].label;

            items += '<li class="b-menu__layout-vert-cell">' +
                        '<div class="b-menu__item' + (lang == curLang ? ' b-menu__item_state_current' : '') + '">' +
                          '<span class="b-menu__item-selector">' +
                            '<a class="b-pseudo-link b-lang-switcher__lang b-keyboard__lang-' + lang + ' b-pseudo-link_is-bem_yes i-bem" href="#" onclick="return {\'b-pseudo-link\':{name:\'b-pseudo-link\'}}">' +
                              '<i class="b-keyboard__lang-ic"></i>' + langLabel +
                            '</a>' +
                          '</span>' +
                        '</div>' +
                      '</li>'; 
        }

        return items;
    };

})(Lego.block['b-keyboard'].Keyboard.prototype.langItems);


(function(oldLangSelector) {

    Lego.block['b-keyboard'].Keyboard.prototype.langSelector = function() {

        if (!this.elem.hasClass('b-keyboard_dropdowna_yes'))
            return oldLangSelector.apply(this, arguments);

        var langId = this.elem.data('lang').id;

        return '<div class="b-keyboard__lang">' +
                '<div class="b-keyboard__lang-i">' +
                    '<div class="b-dropdowna b-dropdowna_color_black b-dropdowna_is-bem_yes i-bem" onclick="return {\'b-dropdowna\':{name:\'b-dropdowna\'}}">' +
                    '<span class="b-dropdowna__switcher">' +
                        '<a class="b-pseudo-link b-pseudo-link_is-bem_yes i-bem b-keyboard__lang-' + langId + '" ' +
                        'onclick="return {\'b-pseudo-link\':{name:\'b-pseudo-link\'}}" href="#">' +
                            '<i class="b-keyboard__lang-ic"></i>' +
                            Lego.block['b-keyboard'].lang[langId].label +
                        '</a>' +
                    '</span>' +
                    '<div class="b-popupa b-popupa_theme_ffffff b-popupa_is-bem_yes ' +
                        'i-bem b-dropdowna__popup b-dropdowna__popup_color_black b-keyboard__lang-selector" ' +
                        'onclick="return {\'b-popupa\':{name:\'b-popupa\'}}">' +
                            '<i class="b-popupa__shadow"></i>' +
                            '<i class="b-popupa__tail">' +
                                '<i class="b-popupa__tail-i"></i>' +
                            '</i>' +
                            '<table cellpadding="0" cellspasing="0" class="b-popupa__wrap">' +
                                '<tr>' +
                                    '<td class="b-popupa__wrap-cell">' +
                                        '<div class="b-popupa__content">' +
                                            '<div class="b-menu b-menu_layout_vert b-menu_preset_vmenu b-menu_is-bem_yes i-bem" onclick="return {\'b-menu\':{name:\'b-menu\'}}">' +
                                                '<ul class="b-menu__layout-vert">' +
                                                this.langItems() +
                    '</ul></div></div></td></tr></table></div></div>' +
                '</div>' +
               '</div>';
    };

})(Lego.block['b-keyboard'].Keyboard.prototype.langSelector);


(function(oldBlockInit) {

    Lego.block['b-keyboard'].Keyboard.prototype.initBlock = function() {
        var elem = this.elem;
        oldBlockInit.apply(this, arguments);
        BEM.DOM.init(this.elem);
    };

})(Lego.block['b-keyboard'].Keyboard.prototype.initBlock);


(function(oldAttachEvents) {

    Lego.block['b-keyboard'].Keyboard.prototype.attachEvents = function() {
        var elem = this.elem;

        if (!elem.hasClass('b-keyboard_dropdowna_yes'))
            return oldAttachEvents.apply(this, arguments);

        var _this = this;

        BEM.blocks['b-menu'].liveCtxBind(
            elem.find('.b-keyboard__lang-selector'),
            'current',
            function(e, data) {
                var a = data.current.find('.b-lang-switcher__lang');
                _this.switchLayout(a[0]);
            }
        );

        // Защита от залипания подсветки нажатой клавиши
        elem
            .find('.' + this.KEY_BLOCK)
            .bind('mouseleave', function() {
                var elem = jQuery(this);
                if (elem.data("pressed") == 1) elem.removeClass(_this.KEY_PRESSED);

                // Выключаем автоповтор
                _this.clearHold();
            });
    };

})(Lego.block['b-keyboard'].Keyboard.prototype.attachEvents);
