<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:exsl="http://exslt.org/common"
    exclude-result-prefixes=" lego x exsl "
    extension-element-prefixes=" exsl "
    version="1.0">

    <xsl:import href="../b-dropdowna/b-dropdowna.convert2xml.xsl"/>
    <xsl:import href="../b-popupa/b-popupa.convert2xml.xsl"/>

<xsl:template match="lego:b-lang-switcher[not(@converted)]">
    <lego:declaration>
        <lego:b-ico/>
        <lego:b-pseudo-link/>
        <lego:b-lang-switcher>
            <lego:popup lego:place="foot"/>
        </lego:b-lang-switcher>
    </lego:declaration>

    <xsl:variable name="lang-switcher-selected">
        <xsl:apply-templates select="." mode="find-selected"/>
    </xsl:variable>

    <xsl:apply-templates select="exsl:node-set($lang-switcher-selected)" mode="convert">
        <xsl:with-param name="is-in-footer" select="(ancestor::lego:b-foot)"/>
    </xsl:apply-templates>

</xsl:template>

<xsl:template match="lego:b-lang-switcher" mode="convert">
    <xsl:param name="is-in-footer" select="false()"/>
    <lego:b-lang-switcher converted="yes">
        <xsl:copy-of select="@*"/>
        <xsl:variable name="dropdowna">
            <lego:b-dropdowna>
                <lego:switcher>
                    <lego:mix>
                        <lego:switcher b="b-lang-switcher"/>
                    </lego:mix>
                    <xsl:apply-templates select="lego:lang[@selected = 'yes']">
                        <xsl:with-param name="link" select="false()"/>
                    </xsl:apply-templates>
                </lego:switcher>
                <lego:b-popupa>
                    <xsl:attribute name="lego:direction">
                        <xsl:choose>
                            <xsl:when test="@direction">
                                <xsl:value-of select="@direction"/>
                            </xsl:when>
                            <xsl:otherwise>up</xsl:otherwise>
                        </xsl:choose>
                    </xsl:attribute>
                    <lego:tail/>
                    <lego:content>
                        <lego:mix>
                            <lego:popup-content b="b-lang-switcher"/>
                        </lego:mix>
                        <lego:b-menu lego:layout="vert" lego:preset="vmenu">
                            <lego:mix>
                                <lego:menu b="b-dropdowna"/>
                                <lego:menu b="b-lang-switcher"/>
                            </lego:mix>
                            <xsl:if test="count(lego:lang) &lt; 5">
                                <lego:item type="more">
                                    <lego:b-link url="http://tune.yandex.ru/lang/"/>
                                </lego:item>
                                <lego:separator/>
                            </xsl:if>
                            <xsl:for-each select="lego:lang">
                                <lego:item lang="{@name}">
                                    <xsl:apply-templates select="."/>
                                </lego:item>
                            </xsl:for-each>
                        </lego:b-menu>
                    </lego:content>
                </lego:b-popupa>
            </lego:b-dropdowna>
        </xsl:variable>
        <xsl:apply-templates select="exsl:node-set($dropdowna)"/>
    </lego:b-lang-switcher>
</xsl:template>

<xsl:template match="lego:b-lang-switcher" mode="find-selected">
    <xsl:copy>
        <xsl:copy-of select="@*"/>
        <xsl:apply-templates select="lego:lang" mode="find-selected"/>
    </xsl:copy>
</xsl:template>

<xsl:template match="lego:b-lang-switcher[lego:lang/@selected = 'yes']/lego:lang" mode="find-selected">
    <xsl:copy-of select="."/>
</xsl:template>

<xsl:template match="lego:b-lang-switcher[not(lego:lang/@selected = 'yes')]/lego:lang" mode="find-selected">
    <xsl:copy>
        <xsl:copy-of select="@*"/>
        <xsl:choose>
            <xsl:when test="@name = $locale">
                <xsl:attribute name="selected">yes</xsl:attribute>
            </xsl:when>
            <xsl:when test="@name = 'ua' and $locale = 'uk'">
                <xsl:attribute name="selected">yes</xsl:attribute>
            </xsl:when>
            <xsl:when test="@name = 'kz' and $locale = 'kk'">
                <xsl:attribute name="selected">yes</xsl:attribute>
            </xsl:when>
            <xsl:when test="@name = 'by' and $locale = 'be'">
                <xsl:attribute name="selected">yes</xsl:attribute>
            </xsl:when>
        </xsl:choose>
    </xsl:copy>
</xsl:template>

<xsl:template match="lego:b-lang-switcher//lego:lang">
    <xsl:param name="link" select="true()"/>
    <xsl:variable name="tag-name">
        <xsl:choose>
            <xsl:when test="$link">b-link</xsl:when>
            <xsl:otherwise>b-pseudo-link</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:element name="lego:{$tag-name}">
        <xsl:attribute name="class">b-lang-switcher__lang</xsl:attribute>
        <xsl:if test="not($link)">
            <xsl:attribute name="lego:is-bem">yes</xsl:attribute>
        </xsl:if>
        <xsl:if test="not(@selected = 'yes')"><xsl:copy-of select="@url"/></xsl:if>
        <xsl:copy-of select="@selected"/>
        <lego:declaration>
            <lego:b-country-flag lego:size-16="{@name}"/>
        </lego:declaration>
        <lego:b-ico alt="{@name}" class="b-lang-switcher__flag b-country-flag b-country-flag_size-16_{@name}"/>
        <xsl:apply-templates select="." mode="content"/>
    </xsl:element>
</xsl:template>

<xsl:template match="lego:b-lang-switcher//lego:lang" mode="content">
    <xsl:choose>
        <xsl:when test="@name = 'ru'">Ru</xsl:when>
        <xsl:when test="@name = 'ua'">Ua</xsl:when>
        <xsl:when test="@name = 'en'">En</xsl:when>
        <xsl:when test="@name = 'kz'">Kz</xsl:when>
        <xsl:when test="@name = 'by'">By</xsl:when>
        <xsl:when test="@name = 'tt'">Tat</xsl:when>
        <xsl:when test="@name = 'tr'">Tr</xsl:when>
    </xsl:choose>
</xsl:template>

<xsl:template match="lego:b-lang-switcher[@lego:extended = 'yes']//lego:lang" mode="content">
    <xsl:choose>
        <xsl:when test="@name = 'ru'">русский</xsl:when>
        <xsl:when test="@name = 'ua'">украинский</xsl:when>
        <xsl:when test="@name = 'en'">английский</xsl:when>
        <xsl:when test="@name = 'kz'">казахский</xsl:when>
        <xsl:when test="@name = 'by'">белорусский</xsl:when>
        <xsl:when test="@name = 'tt'">татарский</xsl:when>
        <xsl:when test="@name = 'tr'">турецкий</xsl:when>
    </xsl:choose>
</xsl:template>

</xsl:stylesheet>
