<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:math="http://exslt.org/math"
    exclude-result-prefixes=" x lego "
    extension-element-prefixes=" math "
    version="1.0">

<xsl:template match="lego:b-link">
    <a>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:copy-of select="@target"/>
        <xsl:apply-templates select="." mode="lego:url"/>
        <xsl:choose>
            <xsl:when test="@show-counter">
                <xsl:apply-templates select="." mode="lego:counter">
                    <xsl:with-param name="show-counter" select="floor(math:random() * 100) &lt;= @show-counter"/>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="." mode="lego:counter"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="." mode="lego:content"/>
    </a>
</xsl:template>

</xsl:stylesheet>
