BEM.DOM.decl('b-menu', {

    onElemSetMod : {

        'trigger' : {

            'state' : function(elem, modName, modVal) {

                this
                    .toggleMod(
                        this.findElem(elem.closest(this.buildSelector('layout-vert-cell')), 'item-content').eq(0),
                        'visibility',
                        'visible',
                        modVal == 'opened')
                    .trigger('trigger', {
                        domElem : elem,
                        state : modVal
                    });

            }

        },

        'item' : {

            'state' : {

                'current' : function(elem) {

                    var _this = this,
                        prev = _this.elem('item', 'state', 'current');

                    // открываем все триггеры более верхнего уровня
                    _this.findElem(
                        elem
                            .parents(_this.buildSelector('item-content'))
                            .prev(_this.buildSelector('item')), 'trigger')
                                .each(function() {
                                    _this.setMod($(this), 'state', 'opened');
                                });

                    _this
                        .delMod(prev, 'state')
                        .trigger('current', {
                            prev    : prev,
                            current : elem
                        });

                }

            }

        }

    },

    onTriggerClick : function(e) {

        e.preventDefault();
        this.toggleMod(e.data.domElem, 'state', 'opened');

    },

    onItemSelectorClick : function(e) {

        var item = this._getItemByEvent(e);
        this.hasMod(item, 'state', 'disabled') || this.setMod(item, 'state', 'current');

    },

    _getItemByEvent : function(e) {
        return e.data.domElem.closest(this.buildSelector('item'));
    }

}, {

    live : function() {

        this
            .liveBindTo('trigger', 'leftclick', function(e) {
                this.onTriggerClick(e);
            })
            .liveBindTo('item-selector', 'leftclick', function(e) {
                this.onItemSelectorClick(e);
            });

    }

});