<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<xsl:template match="lego:b-menu[@lego:layout = 'horiz-simple']" mode="lego:b-menu__layout">
    <xsl:apply-templates select="lego:title"/>
    <xsl:apply-templates select="lego:item" mode="lego:b-menu__layout-cell"/>
</xsl:template>

<xsl:template match="lego:b-menu[@lego:layout = 'horiz-simple']/lego:item" mode="lego:b-menu__layout-cell">
    <xsl:apply-templates select="."/>
    <xsl:apply-templates select="." mode="lego:b-menu__separator"/>
</xsl:template>

<xsl:template match="lego:b-menu[@lego:layout = 'horiz-simple']/lego:item" mode="lego:b-menu__separator">
    <xsl:value-of select="../@separator"/>
</xsl:template>

<xsl:template match="lego:b-menu[@lego:layout = 'horiz-simple']/lego:title">
    <xsl:apply-imports/><xsl:text> </xsl:text>
</xsl:template>

<xsl:template match="lego:b-menu[@lego:layout = 'horiz-simple']/lego:item[not(following-sibling::lego:item)]" mode="lego:b-menu__separator"/>

<xsl:template match="lego:b-menu[@lego:layout = 'horiz-simple']/lego:item">
    <xsl:apply-templates/>
</xsl:template>

<xsl:template match="lego:b-menu[@lego:layout = 'horiz-simple']/lego:item[@lego:state='current']">
    <span class="b-menu__item_state_current">
        <xsl:apply-templates />
    </span>
</xsl:template>

</xsl:stylesheet>