<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<xsl:template match="lego:b-menu[@lego:layout = 'vert']
                   | lego:submenu[ancestor::lego:b-menu[1][@lego:layout = 'vert']]" mode="lego:b-menu__layout">
    <xsl:apply-templates select="lego:title"/>
    <ul class="{lego:name(ancestor-or-self::lego:b-menu[1])}__layout-vert">
        <xsl:apply-templates select="lego:item | lego:separator | lego:gap" mode="lego:b-menu__layout-cell"/>
    </ul>
</xsl:template>

<xsl:template match="lego:item[ancestor::lego:b-menu[1][@lego:layout = 'vert']]
                   | lego:gap[ancestor::lego:b-menu[1][@lego:layout = 'vert']]
                   | lego:separator[ancestor::lego:b-menu[1][@lego:layout = 'vert']]" mode="lego:b-menu__layout-cell">
    <li>
        <xsl:apply-templates select="." mode="lego:b-menu__layout-cell-class"/>
        <xsl:apply-templates select="."/>
    </li>
</xsl:template>

<xsl:template match="lego:item[ancestor::lego:b-menu[1][@lego:layout = 'vert']]">
    <xsl:apply-templates select="lego:title"/>
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="*[not(self::lego:b-menu | self::lego:submenu | self::lego:item-content)]" />
    </div>
    <xsl:apply-templates select="." mode="lego:b-menu__item-content"/>
</xsl:template>

<xsl:template match="lego:b-menu[@lego:layout = 'vert']/lego:item
                   | lego:b-menu[@lego:layout = 'vert']/lego:title
                   | lego:b-menu[@lego:layout = 'vert']/lego:separator
                   | lego:b-menu[@lego:layout = 'vert']/lego:gap
                   | lego:b-menu[@lego:layout = 'vert']//lego:submenu/lego:item
                   | lego:b-menu[@lego:layout = 'vert']//lego:submenu/lego:title
                   | lego:b-menu[@lego:layout = 'vert']//lego:submenu/lego:separator
                   | lego:b-menu[@lego:layout = 'vert']//lego:submenu/lego:gap" mode="lego:b-menu__layout-cell-class">
    <xsl:variable name="class">
        <xsl:text>b-menu__layout-vert-</xsl:text>
        <xsl:value-of select="x:if(self::lego:item, 'cell', local-name())"/>
    </xsl:variable>

    <xsl:attribute name="class">
        <xsl:value-of select="$class"/>
        <xsl:apply-templates select="." mode="lego:cell-position-class-content">
            <xsl:with-param name="class" select="$class"/>
        </xsl:apply-templates>
    </xsl:attribute>
</xsl:template>

</xsl:stylesheet>