<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes="x lego ">

<xsl:template match="lego:b-menu | lego:b-menu//lego:submenu">
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:b-menu__layout"/>
    </div>
</xsl:template>

<xsl:template match="lego:b-menu//lego:item" mode="lego:b-menu__item-content">
    <xsl:apply-templates select="lego:b-menu"/>
</xsl:template>

<xsl:template match="lego:b-menu[@lego:is-bem]//lego:item" mode="lego:b-menu__item-content">
    <div class="b-menu__item-content">
        <xsl:apply-templates select="lego:b-menu | lego:submenu"/>
    </div>
</xsl:template>

<xsl:template match="lego:b-menu//lego:item[lego:item-content]" mode="lego:b-menu__item-content">
    <xsl:apply-templates select="lego:item-content"/>
</xsl:template>

<xsl:template match="lego:b-menu//lego:item-content">
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </div>
</xsl:template>

<xsl:template match="lego:b-menu//lego:item
                    | lego:b-menu//lego:title
                    | lego:b-menu//lego:separator
                    | lego:b-menu//lego:gap" mode="lego:b-menu__layout-cell-class">
    <xsl:variable name="class">
        <xsl:text>b-menu__layout-</xsl:text>
        <xsl:value-of select="x:if(self::lego:item, 'cell', local-name())"/>
    </xsl:variable>

    <xsl:attribute name="class">
        <xsl:value-of select="$class"/>
        <xsl:apply-templates select="." mode="lego:cell-position-class-content">
            <xsl:with-param name="class" select="$class"/>
        </xsl:apply-templates>
    </xsl:attribute>
</xsl:template>

<xsl:template match="lego:b-menu//lego:item
                    | lego:b-menu//lego:title" mode="lego:cell-position-class-content">
    <xsl:param name="class"/>

    <xsl:if test="not(preceding-sibling::lego:item | preceding-sibling::lego:title)">
        <xsl:value-of select="concat(' ', $class, '_position_first')"/>
    </xsl:if>
    <xsl:if test="not(following-sibling::lego:item)">
        <xsl:value-of select="concat(' ', $class, '_position_last')"/>
    </xsl:if>
</xsl:template>

</xsl:stylesheet>

