<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:ya="urn:yandex-functions"
    xmlns:lego="https://lego.yandex-team.ru"
    extension-element-prefixes="x ya"
    exclude-result-prefixes="lego"
    >

    <xsl:template match="lego:b-page">
        <html id="nojs">
            <xsl:apply-templates select="lego:head"/>
            <body>
                <xsl:apply-templates select="." mode="lego:block-attributes"/>
                <xsl:apply-templates select="*[not(self::lego:head)]"/>
            </body>
        </html>
    </xsl:template>

    <xsl:template match="lego:b-page/lego:head">
        <head>
            <xsl:apply-templates select="." mode="lego:meta"/>
            <xsl:apply-templates select="." mode="lego:css"/>
            <xsl:apply-templates select="." mode="lego:js"/>
            <xsl:apply-templates select="." mode="lego:favicon"/>
            <xsl:apply-templates select="." mode="lego:content"/>
        </head>
    </xsl:template>

    <xsl:template match="lego:b-page/lego:head" mode="lego:meta">
        <meta name="MSSmartTagsPreventParsing" content="true"/>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <meta http-equiv="X-UA-Compatible" content="IE=EmulateIE7, IE=edge"/>
        <xsl:apply-templates select="lego:meta" mode="lego:meta"/>
    </xsl:template>

    <xsl:template match="lego:b-page/lego:head/lego:meta[@name and @value]" mode="lego:meta">
        <meta name="{@name}" content="{@value}" />
    </xsl:template>

    <xsl:template match="lego:b-page/lego:head" mode="lego:favicon">
        <link rel="shortcut icon">
            <xsl:attribute name="href">
                <xsl:apply-templates select="." mode="lego:favicon-content"/>
            </xsl:attribute>
        </link>
    </xsl:template>

    <xsl:template match="lego:b-page/lego:head" mode="lego:favicon-content">
        <xsl:text>/favicon.ico</xsl:text>
    </xsl:template>

    <xsl:template match="lego:b-page/lego:head" mode="lego:css">
        <xsl:call-template name="lego:css">
            <xsl:with-param name="meta" select="false()"/>
            <xsl:with-param name="css">
                <xsl:apply-templates select="." mode="lego:css-content"/>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="lego:b-page/lego:head" mode="lego:css-content">
        <xsl:value-of select="concat('_', /lego:page/@lego:name)"/>
    </xsl:template>

    <xsl:template match="lego:b-page/lego:head[lego:css]" mode="lego:css">
        <xsl:apply-templates select="lego:css"/>
    </xsl:template>

    <xsl:template match="lego:b-page/lego:head/lego:css">
        <xsl:call-template name="lego:css">
            <xsl:with-param name="meta" select="false()"/>
            <xsl:with-param name="css" select="."/>
            <xsl:with-param name="ie" select="not(@lego:ie = 'no')"/>
            <xsl:with-param name="ie-only" select="@lego:ie = 'only'"/>
        </xsl:call-template>
    </xsl:template>
    <xsl:template match="lego:b-page/lego:head/lego:css[@lego:inline = 'yes']">
        <xsl:call-template name="lego:css-inline">
            <xsl:with-param name="css" select="."/>
            <xsl:with-param name="ie" select="@lego:ie = 'yes' or @lego:ie = 'only'"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="lego:b-page/lego:head" mode="lego:common-js">
        <xsl:apply-templates select="/" mode="lego:js-include-jquery"/>
        <xsl:call-template name="lego:js">
            <xsl:with-param name="js">
                <xsl:apply-templates select="." mode="lego:js-content"/>
            </xsl:with-param>
        </xsl:call-template>
        <xsl:if test="$lego:locale != 'ru'">
            <xsl:apply-templates select="/" mode="lego:js-include-locale"/>
        </xsl:if>
        <xsl:apply-templates select="/" mode="lego:js-init"/>
    </xsl:template>

    <xsl:template match="lego:b-page/lego:head" mode="lego:js">
        <xsl:apply-templates select="." mode="lego:common-js"/>
    </xsl:template>

    <xsl:template match="lego:b-page/lego:head[lego:js]" mode="lego:js">
        <xsl:apply-templates select="lego:js"/>
    </xsl:template>

    <xsl:template match="lego:b-page/lego:head/lego:js">
        <xsl:call-template name="lego:js">
            <xsl:with-param name="js" select="."/>
        </xsl:call-template>
    </xsl:template>
    <xsl:template match="lego:b-page/lego:head/lego:js[@lego:inline = 'yes']">
        <xsl:call-template name="lego:js-inline">
            <xsl:with-param name="js" select="."/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="lego:b-page/lego:head" mode="lego:js-content">
        <xsl:value-of select="concat('_', /lego:page/@lego:name, '.js')"/>
    </xsl:template>

    <xsl:template match="lego:b-page/lego:head" mode="lego:content">
        <xsl:apply-templates select="node()[not(self::lego:css | self::lego:js | self::lego:meta)]"/>
    </xsl:template>

</xsl:stylesheet>
