<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:exsl="http://exslt.org/common"
    extension-element-prefixes=" exsl "
    exclude-result-prefixes=" lego exsl "
    version="1.0">

    <xsl:import href="../i-popup/i-popup.convert2xml.xsl"/>
    <xsl:include href="../i-bem/i-bem.convert2xml.xsl"/>

    <xsl:template match="lego:b-popupa">
        <lego:declaration>
            <xsl:variable name="decl">
                <lego:i-bem>
                    <lego:dom/>
                    <lego:html/>
                </lego:i-bem>
                <lego:i-popup lego:visibility="visible">
                    <xsl:if test="@lego:direction = 'fixed'">
                        <xsl:attribute name="lego:fixed">yes</xsl:attribute>
                    </xsl:if>
                </lego:i-popup>
            </xsl:variable>
            <xsl:apply-templates select="exsl:node-set($decl)"/>
            <lego:b-popupa>
                <lego:shadow/>
            </lego:b-popupa>
        </lego:declaration>
        <lego:b-popupa lego:theme="ffffff" lego:direction="down" lego:is-bem="yes">
            <xsl:copy-of select="@*"/>
            <xsl:if test="lego:close">
                <xsl:attribute name="lego:has-close">yes</xsl:attribute>
            </xsl:if>
            <xsl:copy-of select="lego:mix"/>
            <xsl:copy-of select="lego:tail | lego:close"/>
            <xsl:apply-templates select="lego:under | lego:content"/>
        </lego:b-popupa>
    </xsl:template>

</xsl:stylesheet>
