<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:str="http://exslt.org/strings"
    exclude-result-prefixes=" x lego str "
    version="1.0">

<xsl:template match="lego:b-popupa">
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>
        <xsl:apply-templates select="lego:tail | lego:close | lego:content"/>
    </div>
</xsl:template>

<xsl:template match="lego:b-popupa/lego:content">
    <i class="b-popupa__shadow"/>
    <table class="b-popupa__wrap" cellpadding="0" cellspacing="0">
    <tr>
        <td class="b-popupa__wrap-cell">
            <div>
                <xsl:apply-templates select="." mode="lego:block-attributes"/>
                <xsl:apply-templates select="." mode="lego:content"/>
            </div>
        </td>
    </tr>
    </table>
</xsl:template>

<xsl:template match="lego:b-popupa" mode="lego:js-params-content">
    <xsl:apply-imports/>
    <xsl:if test="@z-index">
        <xsl:text>,zIndex:</xsl:text>
        <xsl:value-of select="@z-index"/>
    </xsl:if>
    <xsl:if test="@directions">
        <xsl:text>,directions:[</xsl:text>
        <xsl:for-each select="str:tokenize(@directions, ',')">
            <xsl:if test="position() - 1">,</xsl:if>
            <xsl:value-of select="x:js-quote(normalize-space(.))"/>
        </xsl:for-each>
        <xsl:text>]</xsl:text>
    </xsl:if>
</xsl:template>

</xsl:stylesheet>