<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-pseudo-link">
    <span>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:onclick"/>
        <xsl:apply-templates/>
    </span>
</xsl:template>

<xsl:template match="lego:b-pseudo-link[@url]">
    <a>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:url"/>
        <xsl:apply-templates select="." mode="lego:onclick"/>
        <xsl:apply-templates/>
    </a>
</xsl:template>

<xsl:template match="lego:b-pseudo-link[@url]" mode="lego:block-attributes">
    <xsl:apply-imports/>
    <xsl:copy-of select="@target"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template name="lego:b-pseudo-link">
<xsl:param name="content"/>
<xsl:param name="onclick"/>
<xsl:param name="url"/>
<xsl:param name="class"/>
<xsl:param name="counter"/>
<xsl:param name="counter-event" select="'onmousedown'"/>
    <xsl:element name="{lego:if(string($url), 'a', 'span')}">
        <xsl:attribute name="class">
            <xsl:text>b-pseudo-link</xsl:text>
            <xsl:if test="$class">
                <xsl:value-of select="concat(' ', $class)"/>
            </xsl:if>
        </xsl:attribute>
        <xsl:if test="string($url)">
            <xsl:attribute name="href"><xsl:value-of select="$url"/></xsl:attribute>
        </xsl:if>
        <xsl:if test="$onclick">
            <xsl:attribute name="onclick"><xsl:value-of select="$onclick"/></xsl:attribute>
        </xsl:if>
        <xsl:if test="string($counter)">
            <xsl:attribute name="{$counter-event}">
                <xsl:text>Lego.ch(</xsl:text>
                <xsl:value-of select="x:js-quote($counter)"/>
                <xsl:text>,this)</xsl:text>
            </xsl:attribute>
        </xsl:if>
        <xsl:value-of select="$content"/>
    </xsl:element>
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>

