<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-round">
    <div>
    <xsl:call-template name="lego:b-round">
        <xsl:with-param name="radius" select="@radius"/>
        <xsl:with-param name="border" select="@border"/>
        <xsl:with-param name="background" select="@background"/>
        <xsl:with-param name="content">
            <xsl:apply-templates/>
        </xsl:with-param>
    </xsl:call-template>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template name="lego:b-round-corner">
<xsl:param name="corner"/>
<xsl:param name="border"/>
    <i class="{$corner}">
        <i></i>
        <xsl:if test="$border"><b></b></xsl:if>
    </i>
</xsl:template>

<xsl:template name="lego:b-round-border">
<xsl:param name="border"/>
    <xsl:if test="$border">
        <xsl:text> b-round_border_</xsl:text><xsl:value-of select="$border"/>
    </xsl:if>
</xsl:template>

<xsl:template name="lego:b-round-background">
<xsl:param name="background"/>
    <xsl:if test="$background">
        <xsl:text> b-round_background_bg-</xsl:text><xsl:value-of select="$background"/>
    </xsl:if>
</xsl:template>

<xsl:template name="lego:b-round-side">
<xsl:param name="side"/>
<xsl:param name="radius"/>
<xsl:param name="left"/>
<xsl:param name="right"/>
<xsl:param name="border"/>
<xsl:param name="background"/>
    <i>
        <xsl:attribute name="class">
            <xsl:text>b-round b-round_radius_</xsl:text><xsl:value-of select="$radius"/>
            <xsl:call-template name="lego:b-round-border"><xsl:with-param name="border" select="$border"/></xsl:call-template>
            <xsl:call-template name="lego:b-round-background"><xsl:with-param name="background" select="$background"/></xsl:call-template>
        </xsl:attribute>
        <xsl:if test="$left">
            <xsl:call-template name="lego:b-round-corner">
                <xsl:with-param name="corner" select="concat('l ', $side)"/>
                <xsl:with-param name="border" select="$border"/>
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$right">
            <xsl:call-template name="lego:b-round-corner">
                <xsl:with-param name="corner" select="concat('r ', $side)"/>
                <xsl:with-param name="border" select="$border"/>
            </xsl:call-template>
        </xsl:if>
    </i>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template name="lego:b-round">
<xsl:param name="radius" select="2"/>
<xsl:param name="top-left" select="true()"/>
<xsl:param name="top-right" select="true()"/>
<xsl:param name="bottom-left" select="true()"/>
<xsl:param name="bottom-right" select="true()"/>
<xsl:param name="border"/>
<xsl:param name="background"/>
<xsl:param name="content"/>
    <xsl:call-template name="lego:b-round-side">
        <xsl:with-param name="side" select="'t'"/>
        <xsl:with-param name="radius" select="$radius"/>
        <xsl:with-param name="left" select="$top-left"/>
        <xsl:with-param name="right" select="$top-right"/>
        <xsl:with-param name="border" select="$border"/>
        <xsl:with-param name="background" select="$background"/>
    </xsl:call-template>
    <xsl:copy-of select="$content"/>
    <xsl:call-template name="lego:b-round-side">
        <xsl:with-param name="side" select="'b'"/>
        <xsl:with-param name="radius" select="$radius"/>
        <xsl:with-param name="left" select="$bottom-left"/>
        <xsl:with-param name="right" select="$bottom-right"/>
        <xsl:with-param name="border" select="$border"/>
        <xsl:with-param name="background" select="$background"/>
    </xsl:call-template>
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>

