BEM.DOM.decl({ name: 'b-search-filter', modName: 'type', modVal: 'tags' }, {

    onSetMod: {

        js: function() {
            this.singleValue = this.params.count < 2;
            this.hasMod('state', 'all') || this._fillSearchInput()
            this.__base();
        }

    },

    _setInputs: function(state) {
        var _this = this;
        _this._form || (_this._form = _this.domElem.eq(0).closest('form'));
        $.each(_this._getState(state), function(n, v) {
            _this.params.prefix && (v = _this.params.prefix + ':' + v);
            _this._getInput(n).attr('disabled', !v).val(v);
        });
        return _this;
    },

    _getContent: function () {
        return [
            this.__base(),
            this.singleValue ? '' : this._makePopup()
        ]
    },

    _getPopupContent: function () {
        var _this = this,
            switchers = [];
        $.each(this.params.tags, function(n, v){
            if(n != 'all') {
                switchers.length && switchers.push({ tag: 'br' });
                switchers.push({
                    block: 'b-search-filter',
                    elem: 'switcher',
                    mods: { type: n },
                    state: _this.getMod('state'),
                    label: v.label
                });
            }
        });
        return switchers;
    },

    _getText: function () {
        return {
            elem: 'switcher',
            mods: {
                type: this.getMod('state'),
                state: this.singleValue ? 'current' : ''
            },
            tag: this.singleValue ? 'span' : 'a',
            attrs: { href: '' },
            content: [
                this.params.tags[this.getMod('state')].label,
                this.singleValue ? '' : ' <span class="b-search-filter__dropdown">▼</span>'
            ]
        }
    },

    _getState: function (state) {
        state = state || this.getMod('state');
        var a = {};
        a[this.params.param] = this.params.tags[state] ? state : '';
        return a;
    },

    _toggle: function() { this._getPopup().toggle(this.elem('text')) },

    _getPopup: function() {
        return this._popup || (this._popup = this.findBlockInside('b-popupa'))
            .on('outside-click', function(e, data) {
                this.containsDomElem($(data.domEvent.target)) && e.preventDefault();
            }, this);
    }

});
