BEM.DOM.decl('b-search-filter', {

    onSetMod: {

        js: function() {

            this._setInputs();

        },

        state: function(n, v) {
            this
                ._setInputs(v)
                ._form.submit();
        }

    },

    _fillSearchInput: function() {

        var input = this.findBlockOutside('b-search').findBlockInside('input', 'b-form-input');

        input.appendInset(
            BEM.HTML.build({
                    block: 'b-search-filter',
                    mods: this.getMods(),
                    mix: [{ block: 'b-search-filter', elem: 'box' }],
                    js: { uniqId: this.params.uniqId },
                    content: this._getContent()
                }));

        input.on('clear', function() {

            var _this = this;

            input.un('clear');

            $.each(_this._getState(_this.getMods().state), function(n, v) {
                _this._getInput(n).attr('disabled', true).val('');
            });

            this.getMod('js') && this._removeFromInput();

        }, this);

        this.dropElemCache();

        return this;

    },

    _removeFromInput: function() {
        this._input || (this._input = this.findBlockOutside('b-form-input'));
        if (this._input) {
            this._input.removeInset(this.elem('box'), true);
            this
                .delMod('state')
                .dropElemCache();
        }
    },

    _getContent: function() {
        return {
                elem: 'inptok',
                state: this.getMod('state'),
                text: this._getText()
            }
    },

    _getUnderContent: function() { return '' },

    _getText: function() { return '' },

    _getInput: function(n) {
        var cache = this._inputs || (this._inputs = {}),
            res = cache[n] || this._form.find('[class!="inited"][name="' + n + '"]');
        res.length || (res = $('<input class="inited" name="' + n + '" type="hidden"/>').appendTo(this._form));
        return cache[n] = res;
    },

    _setInputs: function(state) {
        var _this = this;
        _this._form || (_this._form = _this.domElem.eq(0).closest('form'));
        $.each(_this._getState(state), function(n, v) {
            _this._getInput(n).attr('disabled', !v).val(v);
        });
        return _this;
    },

    _getState: function(state) { return {} },

    _makePopup: function() {
        return {
                block: 'b-popupa',
                mix: [
                    { block: 'b-search-filter', elem: 'popup' },
                    { block: 'b-search-filter', mods: this.getMods(), js: { uniqId: this.params.uniqId } }
                ],
                content: [
                    { elem: 'tail' },
                    { elem: 'content', content: this._getPopupContent() }
                ]
            }
    },

    _getPopupContent: function() { return '' },

    _toggle: function() { return '' }

}, {

    live: function() {
        this
            .liveBindTo('switcher', 'leftclick', function(e) {
                if (this.getMod(e.data.domElem, 'type')) {
                    this.setMod('state', this.getMod(e.data.domElem, 'type'));
                    e.preventDefault();
                }
            })
            .liveBindTo('text', 'leftclick', function(e) {
                this.singleValue || this._toggle();
                e.preventDefault();
            })
        ;
        return false;
    }

});


BEM.HTML.decl('b-search-filter', {

    onBlock: function(ctx) {
        ctx.tag('span').js(true);
    },

    onElem: {

        under: function(ctx) {
            ctx
                .tag('span')
            //  .param('mix', [{ block: 'b-search', elem: 'precise' }])
                .content(ctx.param('jsBlock')._getUnderContent())
        },

        inptok: function(ctx) {
            ctx
                .tag('span')
                .content({
                    elem: 'inner',
                    tag: 'span',
                    content: [
                        {
                            elem: 'text',
                            tag: 'span',
                            content: ctx.param('text')
                        },
                        {
                            elem: 'switcher',
                            mods: { type: 'all' },
                            mix: [{ block: 'b-search-filter', elem: 'delete' }],
                            content: '×'
                        }
                    ]
                })
        },

        popup: function(ctx) {
            var b = ctx.param('jsBlock');
            ctx
                .attr('style', 'display:none')
                .param('content', {
                    block: 'b-popupa',
                    mix: [
                        { block: 'b-search-filter', elem: 'popup' },
                        { block: 'b-search-filter', mods: b.getMods(), js: { uniqId: b.params.uniqId } }
                    ],
                    content: [
                        { elem: 'tail' },
                        { elem: 'content', content: b._getPopupContent() }
                    ]
                })
        },

        switcher: function(ctx) {
            var isCurrent = ctx.param('state') == ctx.mod('type');
            ctx.content([
                ctx.param('label'),
                isCurrent? ' ✓' : ''
            ]);
            isCurrent ?
                ctx.tag('span').mod('state', 'current') :
                ctx.tag('a').attr('href', '');
        },

        box: function(ctx) {
            ctx.tag('span');
        }

    }

});
