<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:exsl="http://exslt.org/common"
    extension-element-prefixes=" exsl "
    exclude-result-prefixes=" lego exsl "
    version="1.0">

    <xsl:include href="../b-keyboard-loader/b-keyboard-loader.convert2xml.xsl"/>

    <xsl:template match="lego:b-search">
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <xsl:apply-templates select="*"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="lego:b-search//lego:input[not(ancestor::lego:cell | ancestor::lego:params | ancestor::b-form-input)]
        |
        lego:b-search//lego:button[not(ancestor::lego:cell | ancestor::lego:params | ancestor::b-form-input)]">
        <lego:cell>
            <xsl:copy>
                <xsl:copy-of select="@*"/>
                <xsl:apply-templates/>
            </xsl:copy>
        </lego:cell>
        <xsl:apply-templates select="lego:clear"/>
    </xsl:template>

    <xsl:template match="lego:b-search//lego:input/lego:b-form-input/lego:input">
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <xsl:apply-templates select="node()"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="lego:b-search//lego:keyboard-for-foreigner">
        <xsl:copy>
            <xsl:apply-templates/>
        </xsl:copy>
        <lego:declaration>
            <xsl:variable name="b-keyboard-loader">
                <lego:b-keyboard-loader lego:type="search" lego:lang="ru">
                    <lego:flag><lego:b-ico/></lego:flag>
                </lego:b-keyboard-loader>
            </xsl:variable>
            <xsl:apply-templates select="exsl:node-set($b-keyboard-loader)"/>
        </lego:declaration>
    </xsl:template>

    <xsl:template match="lego:b-search//lego:input/lego:clear">
        <lego:declaration>
            <lego:b-input lego:with-clear="yes">
                <lego:clear/>
            </lego:b-input>
        </lego:declaration>
    </xsl:template>

</xsl:stylesheet>
