<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:ya="urn:yandex-functions"
    extension-element-prefixes=" ya "
    exclude-result-prefixes=" lego ya "
    version="1.0">

<!-- quick menu:
        input/b-search__input.xsl
        button/b-search__button.xsl
        sample/b-search__sample.xsl
        precise/b-search__precise.xsl
        advanced/b-search__advanced.xsl
        keyboard-for-foreigner/b-search__keyboard-for-foreigner.xsl
-->

<!-- ############################################################################################################## -->

<xsl:variable name="lego:b-search-default-input-name" select="'text'"/>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-search">
    <form>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:attributes"/>
        <xsl:apply-templates select="." mode="lego:form-attributes"/>
        <xsl:apply-templates select="." mode="lego:counter"/>
        <xsl:apply-templates select="." mode="lego:wai"/>
        <xsl:apply-templates select="." mode="lego:content"/>
        <xsl:apply-templates select="lego:hidden" />
    </form>
</xsl:template>

<xsl:template match="lego:b-search[lego:params()/lego:b-search/@action]" mode="lego:action-content">
    <xsl:value-of select="$lego:params/lego:b-search/@action"/>
</xsl:template>

<xsl:template match="lego:b-search" mode="lego:wai">
    <xsl:attribute name="role">search</xsl:attribute>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-search" mode="lego:counter-event">
    <xsl:text>onsubmit</xsl:text>
</xsl:template>

<xsl:template match="lego:b-search" mode="lego:counter-content">
    <xsl:value-of select="$lego:id"/><xsl:text>.search.form</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-search" mode="lego:content">
    <table class="b-search__table">
        <tr>
            <xsl:apply-templates select="lego:cell"/>
        </tr>
        <xsl:apply-templates select="." mode="lego:under"/>
    </table>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-search" mode="lego:hidden"/>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-search" mode="lego:under">
    <xsl:if test="$lego:params/lego:b-search/lego:input/lego:sample |
        descendant::lego:input/lego:sample/text() |
        $lego:params/lego:b-search/lego:input/lego:precise |
        descendant::lego:input/lego:precise/text() |
        descendant::lego:input/lego:advanced/text() |
        $lego:params/lego:b-search/lego:under |
        descendant::lego:input/lego:under/text() |
        descendant::lego:input/lego:b-suggest">
        <tr>
            <td class="b-search__under" colspan="2">
                <xsl:apply-templates select="descendant::lego:input" mode="lego:under"/>
                <xsl:apply-templates select="lego:suggest"/>
            </td>
        </tr>
    </xsl:if>
</xsl:template>


</xsl:stylesheet>

