(function($, Lego){

Lego.block['b-search__input'] = function(params){

    var _this = $(this);
    var _params = $.extend({focus: false, shortcut: false}, params);

    if(_params.focus || _this.data('lego:focused')) {
        if(!_this.data('lego:focused')) {
            var activeNode = document.activeElement;
            (activeNode && 'input textarea'.indexOf(activeNode.tagName.toLowerCase()) > -1) ||
                setTimeout(function() {
                    _this.focus();
                    if(_this[0].createTextRange) { // ставим каретку в конец для opera и ie
                        var range = _this[0].createTextRange(),
                        len = _this.val().length;

                        range.collapse();
                        range.moveStart('character', len);
                        range.moveEnd('character', len);
                        range.select();
                    }
                    _this.data('lego:focused', true);
                }, 0);
        }
        if(!!window.history.length && !$.trim(_this.val())) { // только если есть хистори и пустое поле
            _this.bind('keydown', function(e) {
                if(e.keyCode == 8) { // если первое нажатие Backspace
                    if (!$.trim(_this.val())) return window.history.back();
                }
                _this.unbind('keydown', arguments.callee);
            });
        }
        _this.blur(function() {
            _this.data('lego:focused', false);
        }).focus(function() { //b-suggest делает blur-focus для установки autocomplete=off, это может сломать инициализацию клавиатуры
            _this.data('lego:focused', true);
        });
    }

    if(_params.shortcut) {
        $(document).keydown(function(e) {
            if(!e.ctrlKey || $(e.target).is('input, textarea')) {
                return;
            }

            if(e.keyCode == 38) {
                _this.focus().select();
            }
        });
    }

};

})(jQuery, window.Lego);
