<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:ya="urn:yandex-functions"
    xmlns:exsl="http://exslt.org/common"
    extension-element-prefixes=" x ya exsl"
    exclude-result-prefixes=" x lego ya exsl "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-search/lego:cell[lego:input]">
    <xsl:apply-templates select="." mode="lego:label"/>
    <td>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="lego:input/lego:b-form-input"/>
        <xsl:apply-templates select="lego:clear"/>
    </td>
</xsl:template>

<xsl:template match="lego:b-search/lego:cell/lego:input/lego:b-form-input" mode="lego:content">
    <xsl:apply-imports/>
    <xsl:apply-templates select="../lego:clear"/>
    <xsl:apply-templates select="../lego:keyboard-for-foreigner"/>
    <xsl:apply-templates select="../lego:b-keyboard-loader"/>
</xsl:template>

<xsl:template match="lego:b-search/lego:cell/lego:input/lego:b-form-input" mode="lego:input-attributes">
    <xsl:apply-imports/>
    <xsl:attribute name="tabindex">1</xsl:attribute>
</xsl:template>

<xsl:template match="lego:b-search/lego:cell" mode="lego:block-class-content">
    <xsl:text>b-search__input</xsl:text>
    <xsl:if test="@class">
        <xsl:text> </xsl:text>
        <xsl:value-of select="@class"/>
    </xsl:if>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-search//lego:input" mode="lego:label"/>

<xsl:template match="lego:b-search[@lego:type = 'double']//lego:input" mode="lego:label">
    <td class="b-search__label-{1 + count(ancestor::lego:cell/preceding-sibling::lego:cell)}">
        <label class="b-search__label">
            <xsl:attribute name="for">
                <xsl:apply-templates select="." mode="lego:auto-id-content"/>
            </xsl:attribute>
            <xsl:apply-templates select="." mode="lego:label-content"/>
        </label>
    </td>
</xsl:template>

<xsl:template match="lego:b-search//lego:input" mode="lego:label-content"/>
<xsl:template match="lego:b-search//lego:input[lego:params()/lego:b-search/lego:input[not(@name != current()/@name)]/lego:label]" mode="lego:label-content">
    <xsl:apply-templates select="$lego:params/lego:b-search/lego:input[not(@name != current()/@name)]/lego:label"/>
</xsl:template>

<xsl:template match="lego:b-search//lego:input[lego:label and not(lego:params()/lego:b-search/lego:input[not(@name != current()/@name)]/lego:label)]" mode="lego:label-content">
    <xsl:apply-templates select="lego:label"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-search//lego:input/lego:clear">
    <a href="#clear" class="b-input__clear g-js">
        <xsl:attribute name="onclick">return {name:'b\-input__clear'}</xsl:attribute>
    </a>
</xsl:template>

<xsl:template match="lego:b-search//lego:input/lego:b-form-input[not(@maxlength)]" mode="lego:maxlength-content">400</xsl:template>

<!-- TODO: Переделать схему с lego:class -->
<xsl:template match="lego:b-search//lego:input[@*[namespace-uri() = 'https://lego.yandex-team.ru']]" mode="lego:class-content">
    <xsl:apply-imports/>
    <xsl:text> g-js</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<!-- для "double"-формы id-шники нужны всегда - для меток -->
<xsl:template match="lego:b-search[@lego:type = 'double']//lego:input" mode="lego:id">
    <xsl:apply-templates select="." mode="lego:auto-id"/>
</xsl:template>

<xsl:template match="lego:b-search//lego:input/lego:b-form-input[not(@name)]" mode="lego:name-content">
    <xsl:value-of select="$lego:b-search-default-input-name"/>
</xsl:template>

<xsl:template match="lego:b-search//lego:input/lego:b-form-input" mode="lego:value-content">
    <xsl:variable name="value" select="$lego:params/lego:b-search//lego:input[not(@name != current()/@name)]/lego:value"/>
    <xsl:choose>
        <xsl:when test="$value">
            <xsl:value-of select="$value"/>
        </xsl:when>
        <xsl:otherwise>
            <xsl:value-of select="lego:input/lego:value"/>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-search//lego:input" mode="lego:under">
    <xsl:apply-templates select="lego:b-suggest"/>
    <xsl:apply-templates select="lego:advanced"/>
    <xsl:apply-templates select="lego:sample | lego:precise"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-search//lego:input" mode="lego:js-params-content">
    <xsl:apply-imports/>

    <xsl:apply-templates select="@focus | @shortcut" mode="lego:js-params-content"/>
</xsl:template>

<xsl:template match="lego:b-search//lego:input/@*" mode="lego:js-params-content">
    <xsl:text>,</xsl:text>
    <xsl:value-of select="x:js-quote(name())"/>
    <xsl:text>:</xsl:text>
    <xsl:choose>
        <xsl:when test=". = 'yes'">true</xsl:when>
        <xsl:otherwise>false</xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="lego:b-search//lego:input/@*[. = '']" mode="lego:js-params-content"/>

</xsl:stylesheet>
